@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.BuildContextArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configuration settings for Docker build context
 * @property contextUri [Required] URI of the Docker build context used to build the image. Supports blob URIs on environment creation and may return blob or Git URIs.
 * <seealso href="https://docs.docker.com/engine/reference/commandline/build/#extended-description" />
 * @property dockerfilePath Path to the Dockerfile in the build context.
 * <seealso href="https://docs.docker.com/engine/reference/builder/" />
 */
public data class BuildContextArgs(
    public val contextUri: Output<String>,
    public val dockerfilePath: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.BuildContextArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.BuildContextArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.BuildContextArgs.builder()
            .contextUri(contextUri.applyValue({ args0 -> args0 }))
            .dockerfilePath(dockerfilePath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BuildContextArgs].
 */
@PulumiTagMarker
public class BuildContextArgsBuilder internal constructor() {
    private var contextUri: Output<String>? = null

    private var dockerfilePath: Output<String>? = null

    /**
     * @param value [Required] URI of the Docker build context used to build the image. Supports blob URIs on environment creation and may return blob or Git URIs.
     * <seealso href="https://docs.docker.com/engine/reference/commandline/build/#extended-description" />
     */
    @JvmName("idguorbroolelbpq")
    public suspend fun contextUri(`value`: Output<String>) {
        this.contextUri = value
    }

    /**
     * @param value Path to the Dockerfile in the build context.
     * <seealso href="https://docs.docker.com/engine/reference/builder/" />
     */
    @JvmName("gnvachhelbvbnans")
    public suspend fun dockerfilePath(`value`: Output<String>) {
        this.dockerfilePath = value
    }

    /**
     * @param value [Required] URI of the Docker build context used to build the image. Supports blob URIs on environment creation and may return blob or Git URIs.
     * <seealso href="https://docs.docker.com/engine/reference/commandline/build/#extended-description" />
     */
    @JvmName("vuuwsbnegigalpac")
    public suspend fun contextUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contextUri = mapped
    }

    /**
     * @param value Path to the Dockerfile in the build context.
     * <seealso href="https://docs.docker.com/engine/reference/builder/" />
     */
    @JvmName("wfsjijengsdwqhhx")
    public suspend fun dockerfilePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dockerfilePath = mapped
    }

    internal fun build(): BuildContextArgs = BuildContextArgs(
        contextUri = contextUri ?: throw PulumiNullFieldException("contextUri"),
        dockerfilePath = dockerfilePath,
    )
}
