@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.CodeVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Code asset version details.
 * @property codeUri Uri where code is located
 * @property description The asset description text.
 * @property isAnonymous If the name version are system generated (anonymous registration).
 * @property isArchived Is the asset archived?
 * @property properties The asset property dictionary.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class CodeVersionArgs(
    public val codeUri: Output<String>? = null,
    public val description: Output<String>? = null,
    public val isAnonymous: Output<Boolean>? = null,
    public val isArchived: Output<Boolean>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.CodeVersionArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.CodeVersionArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.CodeVersionArgs.builder()
            .codeUri(codeUri?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .isAnonymous(isAnonymous?.applyValue({ args0 -> args0 }))
            .isArchived(isArchived?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CodeVersionArgs].
 */
@PulumiTagMarker
public class CodeVersionArgsBuilder internal constructor() {
    private var codeUri: Output<String>? = null

    private var description: Output<String>? = null

    private var isAnonymous: Output<Boolean>? = null

    private var isArchived: Output<Boolean>? = null

    private var properties: Output<Map<String, String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Uri where code is located
     */
    @JvmName("qimuhshrytyoceeo")
    public suspend fun codeUri(`value`: Output<String>) {
        this.codeUri = value
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("mhkrficflpecitpe")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value If the name version are system generated (anonymous registration).
     */
    @JvmName("yfdvmkkcmwyadlbn")
    public suspend fun isAnonymous(`value`: Output<Boolean>) {
        this.isAnonymous = value
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("frjwyonapngguffv")
    public suspend fun isArchived(`value`: Output<Boolean>) {
        this.isArchived = value
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("fternsmcdcuwwrkn")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("grmuqwyjtyjabpar")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Uri where code is located
     */
    @JvmName("qpflebpelueepkxk")
    public suspend fun codeUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeUri = mapped
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("wubjtdxwnbtfgxsc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value If the name version are system generated (anonymous registration).
     */
    @JvmName("byuujfikspiamafc")
    public suspend fun isAnonymous(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAnonymous = mapped
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("xhrylstqgbkttoax")
    public suspend fun isArchived(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchived = mapped
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("wygmaxfvlhrdolpl")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values The asset property dictionary.
     */
    @JvmName("kokptnrgytdbbutm")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("dlfrseccphkqreho")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("nswxkijghjndrnqf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CodeVersionArgs = CodeVersionArgs(
        codeUri = codeUri,
        description = description,
        isAnonymous = isAnonymous,
        isArchived = isArchived,
        properties = properties,
        tags = tags,
    )
}
