@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.CognitiveServicesSkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property capacity
 * @property family
 * @property name
 * @property size
 * @property tier
 */
public data class CognitiveServicesSkuArgs(
    public val capacity: Output<Int>? = null,
    public val family: Output<String>? = null,
    public val name: Output<String>? = null,
    public val size: Output<String>? = null,
    public val tier: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.CognitiveServicesSkuArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.CognitiveServicesSkuArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.CognitiveServicesSkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CognitiveServicesSkuArgs].
 */
@PulumiTagMarker
public class CognitiveServicesSkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var family: Output<String>? = null

    private var name: Output<String>? = null

    private var size: Output<String>? = null

    private var tier: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("wushyrlgibxpfllg")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value
     */
    @JvmName("rrbnuibcresfybww")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value
     */
    @JvmName("imtciqpxjpjflrhs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("rbhggmmmtovbvnje")
    public suspend fun size(`value`: Output<String>) {
        this.size = value
    }

    /**
     * @param value
     */
    @JvmName("xauagrxfsllcddtg")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value
     */
    @JvmName("ftorheckvqplausv")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value
     */
    @JvmName("ntaqpbgbwdwcnesr")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value
     */
    @JvmName("scoweueyhlplaapy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("sdgtavjuruflpbsd")
    public suspend fun size(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value
     */
    @JvmName("konjysqdjfcbosse")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): CognitiveServicesSkuArgs = CognitiveServicesSkuArgs(
        capacity = capacity,
        family = family,
        name = name,
        size = size,
        tier = tier,
    )
}
