@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ColumnTransformerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Column transformer parameters.
 * @property fields Fields to apply transformer logic on.
 * @property parameters Different properties to be passed to transformer.
 * Input expected is dictionary of key,value pairs in JSON format.
 */
public data class ColumnTransformerArgs(
    public val fields: Output<List<String>>? = null,
    public val parameters: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ColumnTransformerArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ColumnTransformerArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ColumnTransformerArgs.builder()
            .fields(fields?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .parameters(parameters?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ColumnTransformerArgs].
 */
@PulumiTagMarker
public class ColumnTransformerArgsBuilder internal constructor() {
    private var fields: Output<List<String>>? = null

    private var parameters: Output<Any>? = null

    /**
     * @param value Fields to apply transformer logic on.
     */
    @JvmName("iqcxxjefvojaolvs")
    public suspend fun fields(`value`: Output<List<String>>) {
        this.fields = value
    }

    @JvmName("eeyvsqxcnfonyyyu")
    public suspend fun fields(vararg values: Output<String>) {
        this.fields = Output.all(values.asList())
    }

    /**
     * @param values Fields to apply transformer logic on.
     */
    @JvmName("srcsuwcdtlhyjmis")
    public suspend fun fields(values: List<Output<String>>) {
        this.fields = Output.all(values)
    }

    /**
     * @param value Different properties to be passed to transformer.
     * Input expected is dictionary of key,value pairs in JSON format.
     */
    @JvmName("vxofpgbrnyiwmoak")
    public suspend fun parameters(`value`: Output<Any>) {
        this.parameters = value
    }

    /**
     * @param value Fields to apply transformer logic on.
     */
    @JvmName("fxfusofigggtdsut")
    public suspend fun fields(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fields = mapped
    }

    /**
     * @param values Fields to apply transformer logic on.
     */
    @JvmName("ukhjyhdxgcmfqbre")
    public suspend fun fields(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fields = mapped
    }

    /**
     * @param value Different properties to be passed to transformer.
     * Input expected is dictionary of key,value pairs in JSON format.
     */
    @JvmName("pjiqecgiahowcxcs")
    public suspend fun parameters(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    internal fun build(): ColumnTransformerArgs = ColumnTransformerArgs(
        fields = fields,
        parameters = parameters,
    )
}
