@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ComputeInstancePropertiesArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ApplicationSharingPolicy
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ComputeInstanceAuthorizationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Compute Instance properties
 * @property applicationSharingPolicy Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role.
 * @property computeInstanceAuthorizationType The Compute Instance Authorization type. Available values are personal (default).
 * @property customServices List of Custom Services added to the compute.
 * @property enableNodePublicIp Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
 * @property personalComputeInstanceSettings Settings for a personal compute instance.
 * @property schedules The list of schedules to be applied on the computes.
 * @property setupScripts Details of customized scripts to execute for setting up the cluster.
 * @property sshSettings Specifies policy and settings for SSH access.
 * @property subnet Virtual network subnet resource ID the compute nodes belong to.
 * @property vmSize Virtual Machine Size
 */
public data class ComputeInstancePropertiesArgs(
    public val applicationSharingPolicy: Output<Either<String, ApplicationSharingPolicy>>? = null,
    public val computeInstanceAuthorizationType:
    Output<Either<String, ComputeInstanceAuthorizationType>>? = null,
    public val customServices: Output<List<CustomServiceArgs>>? = null,
    public val enableNodePublicIp: Output<Boolean>? = null,
    public val personalComputeInstanceSettings: Output<PersonalComputeInstanceSettingsArgs>? = null,
    public val schedules: Output<ComputeSchedulesArgs>? = null,
    public val setupScripts: Output<SetupScriptsArgs>? = null,
    public val sshSettings: Output<ComputeInstanceSshSettingsArgs>? = null,
    public val subnet: Output<ResourceIdArgs>? = null,
    public val vmSize: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ComputeInstancePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.ComputeInstancePropertiesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ComputeInstancePropertiesArgs.builder()
            .applicationSharingPolicy(
                applicationSharingPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .computeInstanceAuthorizationType(
                computeInstanceAuthorizationType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .customServices(
                customServices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enableNodePublicIp(enableNodePublicIp?.applyValue({ args0 -> args0 }))
            .personalComputeInstanceSettings(
                personalComputeInstanceSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .schedules(schedules?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .setupScripts(setupScripts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sshSettings(sshSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vmSize(vmSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ComputeInstancePropertiesArgs].
 */
@PulumiTagMarker
public class ComputeInstancePropertiesArgsBuilder internal constructor() {
    private var applicationSharingPolicy: Output<Either<String, ApplicationSharingPolicy>>? = null

    private var computeInstanceAuthorizationType:
        Output<Either<String, ComputeInstanceAuthorizationType>>? = null

    private var customServices: Output<List<CustomServiceArgs>>? = null

    private var enableNodePublicIp: Output<Boolean>? = null

    private var personalComputeInstanceSettings: Output<PersonalComputeInstanceSettingsArgs>? = null

    private var schedules: Output<ComputeSchedulesArgs>? = null

    private var setupScripts: Output<SetupScriptsArgs>? = null

    private var sshSettings: Output<ComputeInstanceSshSettingsArgs>? = null

    private var subnet: Output<ResourceIdArgs>? = null

    private var vmSize: Output<String>? = null

    /**
     * @param value Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role.
     */
    @JvmName("wosiwtirngdhaqdj")
    public suspend
    fun applicationSharingPolicy(`value`: Output<Either<String, ApplicationSharingPolicy>>) {
        this.applicationSharingPolicy = value
    }

    /**
     * @param value The Compute Instance Authorization type. Available values are personal (default).
     */
    @JvmName("ipdaolxtvblrrdvi")
    public suspend
    fun computeInstanceAuthorizationType(`value`: Output<Either<String, ComputeInstanceAuthorizationType>>) {
        this.computeInstanceAuthorizationType = value
    }

    /**
     * @param value List of Custom Services added to the compute.
     */
    @JvmName("vkooinspnodkjsjy")
    public suspend fun customServices(`value`: Output<List<CustomServiceArgs>>) {
        this.customServices = value
    }

    @JvmName("eclsqwmbqrpgqgey")
    public suspend fun customServices(vararg values: Output<CustomServiceArgs>) {
        this.customServices = Output.all(values.asList())
    }

    /**
     * @param values List of Custom Services added to the compute.
     */
    @JvmName("xeieufcyyetrnqcx")
    public suspend fun customServices(values: List<Output<CustomServiceArgs>>) {
        this.customServices = Output.all(values)
    }

    /**
     * @param value Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
     */
    @JvmName("atjrkgphulquocxy")
    public suspend fun enableNodePublicIp(`value`: Output<Boolean>) {
        this.enableNodePublicIp = value
    }

    /**
     * @param value Settings for a personal compute instance.
     */
    @JvmName("xaqvqwqqhfrwbxjl")
    public suspend
    fun personalComputeInstanceSettings(`value`: Output<PersonalComputeInstanceSettingsArgs>) {
        this.personalComputeInstanceSettings = value
    }

    /**
     * @param value The list of schedules to be applied on the computes.
     */
    @JvmName("ghvrkwmunmncuidp")
    public suspend fun schedules(`value`: Output<ComputeSchedulesArgs>) {
        this.schedules = value
    }

    /**
     * @param value Details of customized scripts to execute for setting up the cluster.
     */
    @JvmName("wnbkhvukhfdkaair")
    public suspend fun setupScripts(`value`: Output<SetupScriptsArgs>) {
        this.setupScripts = value
    }

    /**
     * @param value Specifies policy and settings for SSH access.
     */
    @JvmName("ukoypsbcxuhntaly")
    public suspend fun sshSettings(`value`: Output<ComputeInstanceSshSettingsArgs>) {
        this.sshSettings = value
    }

    /**
     * @param value Virtual network subnet resource ID the compute nodes belong to.
     */
    @JvmName("gjtwrtrqluvugxik")
    public suspend fun subnet(`value`: Output<ResourceIdArgs>) {
        this.subnet = value
    }

    /**
     * @param value Virtual Machine Size
     */
    @JvmName("kkutrdudtnjpfxbs")
    public suspend fun vmSize(`value`: Output<String>) {
        this.vmSize = value
    }

    /**
     * @param value Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role.
     */
    @JvmName("xkomvsmgksqgnvth")
    public suspend fun applicationSharingPolicy(`value`: Either<String, ApplicationSharingPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationSharingPolicy = mapped
    }

    /**
     * @param value Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role.
     */
    @JvmName("jtshyxcpmqyvpyxc")
    public fun applicationSharingPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationSharingPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationSharingPolicy = mapped
    }

    /**
     * @param value Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role.
     */
    @JvmName("xvspauaedosdkckp")
    public fun applicationSharingPolicy(`value`: ApplicationSharingPolicy) {
        val toBeMapped = Either.ofRight<String, ApplicationSharingPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationSharingPolicy = mapped
    }

    /**
     * @param value The Compute Instance Authorization type. Available values are personal (default).
     */
    @JvmName("nkcrkvcidnodscks")
    public suspend
    fun computeInstanceAuthorizationType(`value`: Either<String, ComputeInstanceAuthorizationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeInstanceAuthorizationType = mapped
    }

    /**
     * @param value The Compute Instance Authorization type. Available values are personal (default).
     */
    @JvmName("xllvdurpohespeiy")
    public fun computeInstanceAuthorizationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ComputeInstanceAuthorizationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.computeInstanceAuthorizationType = mapped
    }

    /**
     * @param value The Compute Instance Authorization type. Available values are personal (default).
     */
    @JvmName("bxcegyjxlorklsbs")
    public fun computeInstanceAuthorizationType(`value`: ComputeInstanceAuthorizationType) {
        val toBeMapped = Either.ofRight<String, ComputeInstanceAuthorizationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.computeInstanceAuthorizationType = mapped
    }

    /**
     * @param value List of Custom Services added to the compute.
     */
    @JvmName("clkpygsqhpurdneq")
    public suspend fun customServices(`value`: List<CustomServiceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customServices = mapped
    }

    /**
     * @param argument List of Custom Services added to the compute.
     */
    @JvmName("lekdaigufjwuldbq")
    public suspend fun customServices(argument: List<suspend CustomServiceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomServiceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customServices = mapped
    }

    /**
     * @param argument List of Custom Services added to the compute.
     */
    @JvmName("wrnvsbmeifvhqdud")
    public suspend fun customServices(vararg argument: suspend CustomServiceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CustomServiceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customServices = mapped
    }

    /**
     * @param argument List of Custom Services added to the compute.
     */
    @JvmName("dqmfmbpvpyylnfmn")
    public suspend fun customServices(argument: suspend CustomServiceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CustomServiceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.customServices = mapped
    }

    /**
     * @param values List of Custom Services added to the compute.
     */
    @JvmName("xkcakmqlpegjtvlv")
    public suspend fun customServices(vararg values: CustomServiceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customServices = mapped
    }

    /**
     * @param value Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
     */
    @JvmName("rmntcvfhrtwegwec")
    public suspend fun enableNodePublicIp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableNodePublicIp = mapped
    }

    /**
     * @param value Settings for a personal compute instance.
     */
    @JvmName("heetfliwhsfwstwf")
    public suspend
    fun personalComputeInstanceSettings(`value`: PersonalComputeInstanceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.personalComputeInstanceSettings = mapped
    }

    /**
     * @param argument Settings for a personal compute instance.
     */
    @JvmName("bdkpjkeokkddfuwr")
    public suspend
    fun personalComputeInstanceSettings(argument: suspend PersonalComputeInstanceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = PersonalComputeInstanceSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.personalComputeInstanceSettings = mapped
    }

    /**
     * @param value The list of schedules to be applied on the computes.
     */
    @JvmName("lohgmulrqllhgmod")
    public suspend fun schedules(`value`: ComputeSchedulesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedules = mapped
    }

    /**
     * @param argument The list of schedules to be applied on the computes.
     */
    @JvmName("omwasqlrjajplhbs")
    public suspend fun schedules(argument: suspend ComputeSchedulesArgsBuilder.() -> Unit) {
        val toBeMapped = ComputeSchedulesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedules = mapped
    }

    /**
     * @param value Details of customized scripts to execute for setting up the cluster.
     */
    @JvmName("ibawleugpcmvsirl")
    public suspend fun setupScripts(`value`: SetupScriptsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.setupScripts = mapped
    }

    /**
     * @param argument Details of customized scripts to execute for setting up the cluster.
     */
    @JvmName("amgdfscmqqlgawmx")
    public suspend fun setupScripts(argument: suspend SetupScriptsArgsBuilder.() -> Unit) {
        val toBeMapped = SetupScriptsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.setupScripts = mapped
    }

    /**
     * @param value Specifies policy and settings for SSH access.
     */
    @JvmName("amdxyghxvxmkcmrw")
    public suspend fun sshSettings(`value`: ComputeInstanceSshSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshSettings = mapped
    }

    /**
     * @param argument Specifies policy and settings for SSH access.
     */
    @JvmName("chnhmpyokddvmuit")
    public suspend
    fun sshSettings(argument: suspend ComputeInstanceSshSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ComputeInstanceSshSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sshSettings = mapped
    }

    /**
     * @param value Virtual network subnet resource ID the compute nodes belong to.
     */
    @JvmName("kmlikqjaaxhwrvpn")
    public suspend fun subnet(`value`: ResourceIdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument Virtual network subnet resource ID the compute nodes belong to.
     */
    @JvmName("moxktynupurmbtoi")
    public suspend fun subnet(argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    /**
     * @param value Virtual Machine Size
     */
    @JvmName("drphnfurjsgcfyqq")
    public suspend fun vmSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    internal fun build(): ComputeInstancePropertiesArgs = ComputeInstancePropertiesArgs(
        applicationSharingPolicy = applicationSharingPolicy,
        computeInstanceAuthorizationType = computeInstanceAuthorizationType,
        customServices = customServices,
        enableNodePublicIp = enableNodePublicIp,
        personalComputeInstanceSettings = personalComputeInstanceSettings,
        schedules = schedules,
        setupScripts = setupScripts,
        sshSettings = sshSettings,
        subnet = subnet,
        vmSize = vmSize,
    )
}
