@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.DataLakeAnalyticsSchemaPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataLakeStoreAccountName DataLake Store Account Name
 */
public data class DataLakeAnalyticsSchemaPropertiesArgs(
    public val dataLakeStoreAccountName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.DataLakeAnalyticsSchemaPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.DataLakeAnalyticsSchemaPropertiesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.DataLakeAnalyticsSchemaPropertiesArgs.builder()
            .dataLakeStoreAccountName(dataLakeStoreAccountName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataLakeAnalyticsSchemaPropertiesArgs].
 */
@PulumiTagMarker
public class DataLakeAnalyticsSchemaPropertiesArgsBuilder internal constructor() {
    private var dataLakeStoreAccountName: Output<String>? = null

    /**
     * @param value DataLake Store Account Name
     */
    @JvmName("ybsngnlwtyuygcfg")
    public suspend fun dataLakeStoreAccountName(`value`: Output<String>) {
        this.dataLakeStoreAccountName = value
    }

    /**
     * @param value DataLake Store Account Name
     */
    @JvmName("gqjtsuiaweonsqbt")
    public suspend fun dataLakeStoreAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataLakeStoreAccountName = mapped
    }

    internal fun build(): DataLakeAnalyticsSchemaPropertiesArgs =
        DataLakeAnalyticsSchemaPropertiesArgs(
            dataLakeStoreAccountName = dataLakeStoreAccountName,
        )
}
