@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestDataPathArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property datastoreName The datastore name.
 * @property relativePath Path within the datastore.
 */
public data class DatasetCreateRequestDataPathArgs(
    public val datastoreName: Output<String>? = null,
    public val relativePath: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestDataPathArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestDataPathArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestDataPathArgs.builder()
            .datastoreName(datastoreName?.applyValue({ args0 -> args0 }))
            .relativePath(relativePath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatasetCreateRequestDataPathArgs].
 */
@PulumiTagMarker
public class DatasetCreateRequestDataPathArgsBuilder internal constructor() {
    private var datastoreName: Output<String>? = null

    private var relativePath: Output<String>? = null

    /**
     * @param value The datastore name.
     */
    @JvmName("schnjyckhifjcejt")
    public suspend fun datastoreName(`value`: Output<String>) {
        this.datastoreName = value
    }

    /**
     * @param value Path within the datastore.
     */
    @JvmName("oljhhncupyhtwbco")
    public suspend fun relativePath(`value`: Output<String>) {
        this.relativePath = value
    }

    /**
     * @param value The datastore name.
     */
    @JvmName("ugqjblixsingkmgn")
    public suspend fun datastoreName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datastoreName = mapped
    }

    /**
     * @param value Path within the datastore.
     */
    @JvmName("pmqntrusckdxhwde")
    public suspend fun relativePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relativePath = mapped
    }

    internal fun build(): DatasetCreateRequestDataPathArgs = DatasetCreateRequestDataPathArgs(
        datastoreName = datastoreName,
        relativePath = relativePath,
    )
}
