@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestRegistrationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property description The description for the dataset.
 * @property name The name of the dataset.
 * @property tags Tags associated with the dataset.
 */
public data class DatasetCreateRequestRegistrationArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestRegistrationArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestRegistrationArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestRegistrationArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DatasetCreateRequestRegistrationArgs].
 */
@PulumiTagMarker
public class DatasetCreateRequestRegistrationArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description for the dataset.
     */
    @JvmName("objyjyixyflyypwv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the dataset.
     */
    @JvmName("lyvqnxlwdhpgewmm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Tags associated with the dataset.
     */
    @JvmName("shnhicgwcsshkgus")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description for the dataset.
     */
    @JvmName("ywrijiuxeytwuxky")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the dataset.
     */
    @JvmName("jtchpcdtnhpifwqj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Tags associated with the dataset.
     */
    @JvmName("sywmfpaguxbsnvyw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags associated with the dataset.
     */
    @JvmName("jpdwsgjbetgabkib")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DatasetCreateRequestRegistrationArgs = DatasetCreateRequestRegistrationArgs(
        description = description,
        name = name,
        tags = tags,
    )
}
