@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestTimeSeriesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property coarseGrainTimestamp Column name to be used as CoarseGrainTimestamp. Can only be used if 'fineGrainTimestamp' is specified and cannot be same as 'fineGrainTimestamp'.
 * @property fineGrainTimestamp  Column name to be used as FineGrainTimestamp
 */
public data class DatasetCreateRequestTimeSeriesArgs(
    public val coarseGrainTimestamp: Output<String>? = null,
    public val fineGrainTimestamp: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestTimeSeriesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestTimeSeriesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestTimeSeriesArgs.builder()
            .coarseGrainTimestamp(coarseGrainTimestamp?.applyValue({ args0 -> args0 }))
            .fineGrainTimestamp(fineGrainTimestamp?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatasetCreateRequestTimeSeriesArgs].
 */
@PulumiTagMarker
public class DatasetCreateRequestTimeSeriesArgsBuilder internal constructor() {
    private var coarseGrainTimestamp: Output<String>? = null

    private var fineGrainTimestamp: Output<String>? = null

    /**
     * @param value Column name to be used as CoarseGrainTimestamp. Can only be used if 'fineGrainTimestamp' is specified and cannot be same as 'fineGrainTimestamp'.
     */
    @JvmName("jovmoocpxesdxtkn")
    public suspend fun coarseGrainTimestamp(`value`: Output<String>) {
        this.coarseGrainTimestamp = value
    }

    /**
     * @param value  Column name to be used as FineGrainTimestamp
     */
    @JvmName("igxexyumablaromn")
    public suspend fun fineGrainTimestamp(`value`: Output<String>) {
        this.fineGrainTimestamp = value
    }

    /**
     * @param value Column name to be used as CoarseGrainTimestamp. Can only be used if 'fineGrainTimestamp' is specified and cannot be same as 'fineGrainTimestamp'.
     */
    @JvmName("kyaegbtpdylmtncj")
    public suspend fun coarseGrainTimestamp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coarseGrainTimestamp = mapped
    }

    /**
     * @param value  Column name to be used as FineGrainTimestamp
     */
    @JvmName("lntnyhoedycramfe")
    public suspend fun fineGrainTimestamp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fineGrainTimestamp = mapped
    }

    internal fun build(): DatasetCreateRequestTimeSeriesArgs = DatasetCreateRequestTimeSeriesArgs(
        coarseGrainTimestamp = coarseGrainTimestamp,
        fineGrainTimestamp = fineGrainTimestamp,
    )
}
