@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.DefaultScaleSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property scaleType
 * Expected value is 'Default'.
 */
public data class DefaultScaleSettingsArgs(
    public val scaleType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.DefaultScaleSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.DefaultScaleSettingsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.DefaultScaleSettingsArgs.builder()
            .scaleType(scaleType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefaultScaleSettingsArgs].
 */
@PulumiTagMarker
public class DefaultScaleSettingsArgsBuilder internal constructor() {
    private var scaleType: Output<String>? = null

    /**
     * @param value
     * Expected value is 'Default'.
     */
    @JvmName("ibbhijtexiatsrfi")
    public suspend fun scaleType(`value`: Output<String>) {
        this.scaleType = value
    }

    /**
     * @param value
     * Expected value is 'Default'.
     */
    @JvmName("rqbfumvkkpyoolax")
    public suspend fun scaleType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleType = mapped
    }

    internal fun build(): DefaultScaleSettingsArgs = DefaultScaleSettingsArgs(
        scaleType = scaleType ?: throw PulumiNullFieldException("scaleType"),
    )
}
