@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.EndpointAuthKeysArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Keys for endpoint authentication.
 * @property primaryKey The primary key.
 * @property secondaryKey The secondary key.
 */
public data class EndpointAuthKeysArgs(
    public val primaryKey: Output<String>? = null,
    public val secondaryKey: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.EndpointAuthKeysArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.EndpointAuthKeysArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.EndpointAuthKeysArgs.builder()
            .primaryKey(primaryKey?.applyValue({ args0 -> args0 }))
            .secondaryKey(secondaryKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointAuthKeysArgs].
 */
@PulumiTagMarker
public class EndpointAuthKeysArgsBuilder internal constructor() {
    private var primaryKey: Output<String>? = null

    private var secondaryKey: Output<String>? = null

    /**
     * @param value The primary key.
     */
    @JvmName("qxgljnwkntchsqje")
    public suspend fun primaryKey(`value`: Output<String>) {
        this.primaryKey = value
    }

    /**
     * @param value The secondary key.
     */
    @JvmName("gmpdcpixqglwolkl")
    public suspend fun secondaryKey(`value`: Output<String>) {
        this.secondaryKey = value
    }

    /**
     * @param value The primary key.
     */
    @JvmName("lxtdlieopyxvegyn")
    public suspend fun primaryKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryKey = mapped
    }

    /**
     * @param value The secondary key.
     */
    @JvmName("lbtfiwucxbddyngw")
    public suspend fun secondaryKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryKey = mapped
    }

    internal fun build(): EndpointAuthKeysArgs = EndpointAuthKeysArgs(
        primaryKey = primaryKey,
        secondaryKey = secondaryKey,
    )
}
