@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.EndpointDeploymentModelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property format Model format
 * @property name Model name.
 * @property source Optional. Deployment model source ARM resource ID.
 * @property version Model version.
 */
public data class EndpointDeploymentModelArgs(
    public val format: Output<String>? = null,
    public val name: Output<String>? = null,
    public val source: Output<String>? = null,
    public val version: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.EndpointDeploymentModelArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.EndpointDeploymentModelArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.EndpointDeploymentModelArgs.builder()
            .format(format?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointDeploymentModelArgs].
 */
@PulumiTagMarker
public class EndpointDeploymentModelArgsBuilder internal constructor() {
    private var format: Output<String>? = null

    private var name: Output<String>? = null

    private var source: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Model format
     */
    @JvmName("lewxbvyuupjpnjgv")
    public suspend fun format(`value`: Output<String>) {
        this.format = value
    }

    /**
     * @param value Model name.
     */
    @JvmName("uduogtriqrlfeeti")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Optional. Deployment model source ARM resource ID.
     */
    @JvmName("aehhtkahfybsslip")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value Model version.
     */
    @JvmName("ecwvurjkivnvappr")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Model format
     */
    @JvmName("wnfrdsjtgfmeqjvh")
    public suspend fun format(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Model name.
     */
    @JvmName("gddcfcmtagrdlttf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Optional. Deployment model source ARM resource ID.
     */
    @JvmName("ybueeaxpfercmter")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Model version.
     */
    @JvmName("vkgymakvbyduafrb")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): EndpointDeploymentModelArgs = EndpointDeploymentModelArgs(
        format = format,
        name = name,
        source = source,
        version = version,
    )
}
