@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.EnvironmentVariableArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.EnvironmentVariableType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Environment Variables for the container
 * @property type Type of the Environment Variable. Possible values are: local - For local variable
 * @property value Value of the Environment variable
 */
public data class EnvironmentVariableArgs(
    public val type: Output<Either<String, EnvironmentVariableType>>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.EnvironmentVariableArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.EnvironmentVariableArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.EnvironmentVariableArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvironmentVariableArgs].
 */
@PulumiTagMarker
public class EnvironmentVariableArgsBuilder internal constructor() {
    private var type: Output<Either<String, EnvironmentVariableType>>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Type of the Environment Variable. Possible values are: local - For local variable
     */
    @JvmName("ibyufkuqknuqrujn")
    public suspend fun type(`value`: Output<Either<String, EnvironmentVariableType>>) {
        this.type = value
    }

    /**
     * @param value Value of the Environment variable
     */
    @JvmName("hfhyfwjwmibmphyp")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Type of the Environment Variable. Possible values are: local - For local variable
     */
    @JvmName("lntepujhvghqrtdo")
    public suspend fun type(`value`: Either<String, EnvironmentVariableType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of the Environment Variable. Possible values are: local - For local variable
     */
    @JvmName("xxrkualsqxrsqlil")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnvironmentVariableType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of the Environment Variable. Possible values are: local - For local variable
     */
    @JvmName("ngtasbtufsgotnss")
    public fun type(`value`: EnvironmentVariableType) {
        val toBeMapped = Either.ofRight<String, EnvironmentVariableType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Value of the Environment variable
     */
    @JvmName("odeixleyjmmyvyie")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): EnvironmentVariableArgs = EnvironmentVariableArgs(
        type = type,
        `value` = `value`,
    )
}
