@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetComponentVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Container name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property version Version identifier.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class GetComponentVersionPlainArgs(
    public val name: String,
    public val resourceGroupName: String,
    public val version: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetComponentVersionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.GetComponentVersionPlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GetComponentVersionPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .version(version.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetComponentVersionPlainArgs].
 */
@PulumiTagMarker
public class GetComponentVersionPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var resourceGroupName: String? = null

    private var version: String? = null

    private var workspaceName: String? = null

    /**
     * @param value Container name.
     */
    @JvmName("vioagbvgqmniitgs")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sudyyjbrmcxuoyjx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Version identifier.
     */
    @JvmName("tcfwjqdjmubbcpwg")
    public suspend fun version(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.version = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("sqdbmouujpctkeid")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetComponentVersionPlainArgs = GetComponentVersionPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        version = version ?: throw PulumiNullFieldException("version"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
