@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetInferenceEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpointName InferenceEndpoint name.
 * @property poolName InferencePool name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class GetInferenceEndpointPlainArgs(
    public val endpointName: String,
    public val poolName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetInferenceEndpointPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.GetInferenceEndpointPlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GetInferenceEndpointPlainArgs.builder()
            .endpointName(endpointName.let({ args0 -> args0 }))
            .poolName(poolName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInferenceEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetInferenceEndpointPlainArgsBuilder internal constructor() {
    private var endpointName: String? = null

    private var poolName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value InferenceEndpoint name.
     */
    @JvmName("ucrylueiilrtrntl")
    public suspend fun endpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endpointName = mapped
    }

    /**
     * @param value InferencePool name.
     */
    @JvmName("eevooyffqqkgmufx")
    public suspend fun poolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.poolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gljtymwmdbpgawkc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("pgcnmysddmhiqjnv")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetInferenceEndpointPlainArgs = GetInferenceEndpointPlainArgs(
        endpointName = endpointName ?: throw PulumiNullFieldException("endpointName"),
        poolName = poolName ?: throw PulumiNullFieldException("poolName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
