@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetMachineLearningDatastorePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property datastoreName The Datastore name.
 * @property resourceGroupName Name of the resource group in which workspace is located.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class GetMachineLearningDatastorePlainArgs(
    public val datastoreName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetMachineLearningDatastorePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.GetMachineLearningDatastorePlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GetMachineLearningDatastorePlainArgs.builder()
            .datastoreName(datastoreName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMachineLearningDatastorePlainArgs].
 */
@PulumiTagMarker
public class GetMachineLearningDatastorePlainArgsBuilder internal constructor() {
    private var datastoreName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The Datastore name.
     */
    @JvmName("sovqrdbmvynfeoma")
    public suspend fun datastoreName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.datastoreName = mapped
    }

    /**
     * @param value Name of the resource group in which workspace is located.
     */
    @JvmName("jyxkrbcnajqfqhuc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("ixawdmwmquumocki")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetMachineLearningDatastorePlainArgs = GetMachineLearningDatastorePlainArgs(
        datastoreName = datastoreName ?: throw PulumiNullFieldException("datastoreName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
