@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.IdentityForCmkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Identity that will be used to access key vault for encryption at rest
 * @property userAssignedIdentity The ArmId of the user assigned identity that will be used to access the customer managed key vault
 */
public data class IdentityForCmkArgs(
    public val userAssignedIdentity: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.IdentityForCmkArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.IdentityForCmkArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.IdentityForCmkArgs.builder()
            .userAssignedIdentity(userAssignedIdentity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IdentityForCmkArgs].
 */
@PulumiTagMarker
public class IdentityForCmkArgsBuilder internal constructor() {
    private var userAssignedIdentity: Output<String>? = null

    /**
     * @param value The ArmId of the user assigned identity that will be used to access the customer managed key vault
     */
    @JvmName("llffyxfebtebqvrx")
    public suspend fun userAssignedIdentity(`value`: Output<String>) {
        this.userAssignedIdentity = value
    }

    /**
     * @param value The ArmId of the user assigned identity that will be used to access the customer managed key vault
     */
    @JvmName("byfaptsegehaytgb")
    public suspend fun userAssignedIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentity = mapped
    }

    internal fun build(): IdentityForCmkArgs = IdentityForCmkArgs(
        userAssignedIdentity = userAssignedIdentity,
    )
}
