@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ImageLimitSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Limit settings for the AutoML job.
 * @property maxConcurrentTrials Maximum number of concurrent AutoML iterations.
 * @property maxTrials Maximum number of AutoML iterations.
 * @property timeout AutoML job timeout.
 */
public data class ImageLimitSettingsArgs(
    public val maxConcurrentTrials: Output<Int>? = null,
    public val maxTrials: Output<Int>? = null,
    public val timeout: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ImageLimitSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.ImageLimitSettingsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ImageLimitSettingsArgs.builder()
            .maxConcurrentTrials(maxConcurrentTrials?.applyValue({ args0 -> args0 }))
            .maxTrials(maxTrials?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageLimitSettingsArgs].
 */
@PulumiTagMarker
public class ImageLimitSettingsArgsBuilder internal constructor() {
    private var maxConcurrentTrials: Output<Int>? = null

    private var maxTrials: Output<Int>? = null

    private var timeout: Output<String>? = null

    /**
     * @param value Maximum number of concurrent AutoML iterations.
     */
    @JvmName("cmunbjfvhloihbim")
    public suspend fun maxConcurrentTrials(`value`: Output<Int>) {
        this.maxConcurrentTrials = value
    }

    /**
     * @param value Maximum number of AutoML iterations.
     */
    @JvmName("lbgcxauxebtkhyah")
    public suspend fun maxTrials(`value`: Output<Int>) {
        this.maxTrials = value
    }

    /**
     * @param value AutoML job timeout.
     */
    @JvmName("dahryrohxddrsiqw")
    public suspend fun timeout(`value`: Output<String>) {
        this.timeout = value
    }

    /**
     * @param value Maximum number of concurrent AutoML iterations.
     */
    @JvmName("ymxeobnmvfrjknmt")
    public suspend fun maxConcurrentTrials(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentTrials = mapped
    }

    /**
     * @param value Maximum number of AutoML iterations.
     */
    @JvmName("wktwjtesnqdsdytd")
    public suspend fun maxTrials(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxTrials = mapped
    }

    /**
     * @param value AutoML job timeout.
     */
    @JvmName("skmklubcqlbopank")
    public suspend fun timeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): ImageLimitSettingsArgs = ImageLimitSettingsArgs(
        maxConcurrentTrials = maxConcurrentTrials,
        maxTrials = maxTrials,
        timeout = timeout,
    )
}
