@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ImageModelDistributionSettingsClassificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Distribution expressions to sweep over values of model settings.
 * <example>
 * Some examples are:
 * ```
 * ModelName = "choice('seresnext', 'resnest50')";
 * LearningRate = "uniform(0.001, 0.01)";
 * LayersToFreeze = "choice(0, 2)";
 * ```</example>
 * For more details on how to compose distribution expressions please check the documentation:
 * https://docs.microsoft.com/en-us/azure/machine-learning/how-to-tune-hyperparameters
 * For more information on the available settings please visit the official documentation:
 * https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
 * @property amsGradient Enable AMSGrad when optimizer is 'adam' or 'adamw'.
 * @property augmentations Settings for using Augmentations.
 * @property beta1 Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
 * @property beta2 Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
 * @property distributed Whether to use distributer training.
 * @property earlyStopping Enable early stopping logic during training.
 * @property earlyStoppingDelay Minimum number of epochs or validation evaluations to wait before primary metric improvement
 * is tracked for early stopping. Must be a positive integer.
 * @property earlyStoppingPatience Minimum number of epochs or validation evaluations with no primary metric improvement before
 * the run is stopped. Must be a positive integer.
 * @property enableOnnxNormalization Enable normalization when exporting ONNX model.
 * @property evaluationFrequency Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
 * @property gradientAccumulationStep Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
 * updating the model weights while accumulating the gradients of those steps, and then using
 * the accumulated gradients to compute the weight updates. Must be a positive integer.
 * @property layersToFreeze Number of layers to freeze for the model. Must be a positive integer.
 * For instance, passing 2 as value for 'seresnext' means
 * freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
 * see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
 * @property learningRate Initial learning rate. Must be a float in the range [0, 1].
 * @property learningRateScheduler Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
 * @property modelName Name of the model to use for training.
 * For more information on the available models please visit the official documentation:
 * https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
 * @property momentum Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
 * @property nesterov Enable nesterov when optimizer is 'sgd'.
 * @property numberOfEpochs Number of training epochs. Must be a positive integer.
 * @property numberOfWorkers Number of data loader workers. Must be a non-negative integer.
 * @property optimizer Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
 * @property randomSeed Random seed to be used when using deterministic training.
 * @property stepLRGamma Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
 * @property stepLRStepSize Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
 * @property trainingBatchSize Training batch size. Must be a positive integer.
 * @property trainingCropSize Image crop size that is input to the neural network for the training dataset. Must be a positive integer.
 * @property validationBatchSize Validation batch size. Must be a positive integer.
 * @property validationCropSize Image crop size that is input to the neural network for the validation dataset. Must be a positive integer.
 * @property validationResizeSize Image size to which to resize before cropping for validation dataset. Must be a positive integer.
 * @property warmupCosineLRCycles Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
 * @property warmupCosineLRWarmupEpochs Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
 * @property weightDecay Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
 * @property weightedLoss Weighted loss. The accepted values are 0 for no weighted loss.
 * 1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be 0 or 1 or 2.
 */
public data class ImageModelDistributionSettingsClassificationArgs(
    public val amsGradient: Output<String>? = null,
    public val augmentations: Output<String>? = null,
    public val beta1: Output<String>? = null,
    public val beta2: Output<String>? = null,
    public val distributed: Output<String>? = null,
    public val earlyStopping: Output<String>? = null,
    public val earlyStoppingDelay: Output<String>? = null,
    public val earlyStoppingPatience: Output<String>? = null,
    public val enableOnnxNormalization: Output<String>? = null,
    public val evaluationFrequency: Output<String>? = null,
    public val gradientAccumulationStep: Output<String>? = null,
    public val layersToFreeze: Output<String>? = null,
    public val learningRate: Output<String>? = null,
    public val learningRateScheduler: Output<String>? = null,
    public val modelName: Output<String>? = null,
    public val momentum: Output<String>? = null,
    public val nesterov: Output<String>? = null,
    public val numberOfEpochs: Output<String>? = null,
    public val numberOfWorkers: Output<String>? = null,
    public val optimizer: Output<String>? = null,
    public val randomSeed: Output<String>? = null,
    public val stepLRGamma: Output<String>? = null,
    public val stepLRStepSize: Output<String>? = null,
    public val trainingBatchSize: Output<String>? = null,
    public val trainingCropSize: Output<String>? = null,
    public val validationBatchSize: Output<String>? = null,
    public val validationCropSize: Output<String>? = null,
    public val validationResizeSize: Output<String>? = null,
    public val warmupCosineLRCycles: Output<String>? = null,
    public val warmupCosineLRWarmupEpochs: Output<String>? = null,
    public val weightDecay: Output<String>? = null,
    public val weightedLoss: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ImageModelDistributionSettingsClassificationArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.ImageModelDistributionSettingsClassificationArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ImageModelDistributionSettingsClassificationArgs.builder()
            .amsGradient(amsGradient?.applyValue({ args0 -> args0 }))
            .augmentations(augmentations?.applyValue({ args0 -> args0 }))
            .beta1(beta1?.applyValue({ args0 -> args0 }))
            .beta2(beta2?.applyValue({ args0 -> args0 }))
            .distributed(distributed?.applyValue({ args0 -> args0 }))
            .earlyStopping(earlyStopping?.applyValue({ args0 -> args0 }))
            .earlyStoppingDelay(earlyStoppingDelay?.applyValue({ args0 -> args0 }))
            .earlyStoppingPatience(earlyStoppingPatience?.applyValue({ args0 -> args0 }))
            .enableOnnxNormalization(enableOnnxNormalization?.applyValue({ args0 -> args0 }))
            .evaluationFrequency(evaluationFrequency?.applyValue({ args0 -> args0 }))
            .gradientAccumulationStep(gradientAccumulationStep?.applyValue({ args0 -> args0 }))
            .layersToFreeze(layersToFreeze?.applyValue({ args0 -> args0 }))
            .learningRate(learningRate?.applyValue({ args0 -> args0 }))
            .learningRateScheduler(learningRateScheduler?.applyValue({ args0 -> args0 }))
            .modelName(modelName?.applyValue({ args0 -> args0 }))
            .momentum(momentum?.applyValue({ args0 -> args0 }))
            .nesterov(nesterov?.applyValue({ args0 -> args0 }))
            .numberOfEpochs(numberOfEpochs?.applyValue({ args0 -> args0 }))
            .numberOfWorkers(numberOfWorkers?.applyValue({ args0 -> args0 }))
            .optimizer(optimizer?.applyValue({ args0 -> args0 }))
            .randomSeed(randomSeed?.applyValue({ args0 -> args0 }))
            .stepLRGamma(stepLRGamma?.applyValue({ args0 -> args0 }))
            .stepLRStepSize(stepLRStepSize?.applyValue({ args0 -> args0 }))
            .trainingBatchSize(trainingBatchSize?.applyValue({ args0 -> args0 }))
            .trainingCropSize(trainingCropSize?.applyValue({ args0 -> args0 }))
            .validationBatchSize(validationBatchSize?.applyValue({ args0 -> args0 }))
            .validationCropSize(validationCropSize?.applyValue({ args0 -> args0 }))
            .validationResizeSize(validationResizeSize?.applyValue({ args0 -> args0 }))
            .warmupCosineLRCycles(warmupCosineLRCycles?.applyValue({ args0 -> args0 }))
            .warmupCosineLRWarmupEpochs(warmupCosineLRWarmupEpochs?.applyValue({ args0 -> args0 }))
            .weightDecay(weightDecay?.applyValue({ args0 -> args0 }))
            .weightedLoss(weightedLoss?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageModelDistributionSettingsClassificationArgs].
 */
@PulumiTagMarker
public class ImageModelDistributionSettingsClassificationArgsBuilder internal constructor() {
    private var amsGradient: Output<String>? = null

    private var augmentations: Output<String>? = null

    private var beta1: Output<String>? = null

    private var beta2: Output<String>? = null

    private var distributed: Output<String>? = null

    private var earlyStopping: Output<String>? = null

    private var earlyStoppingDelay: Output<String>? = null

    private var earlyStoppingPatience: Output<String>? = null

    private var enableOnnxNormalization: Output<String>? = null

    private var evaluationFrequency: Output<String>? = null

    private var gradientAccumulationStep: Output<String>? = null

    private var layersToFreeze: Output<String>? = null

    private var learningRate: Output<String>? = null

    private var learningRateScheduler: Output<String>? = null

    private var modelName: Output<String>? = null

    private var momentum: Output<String>? = null

    private var nesterov: Output<String>? = null

    private var numberOfEpochs: Output<String>? = null

    private var numberOfWorkers: Output<String>? = null

    private var optimizer: Output<String>? = null

    private var randomSeed: Output<String>? = null

    private var stepLRGamma: Output<String>? = null

    private var stepLRStepSize: Output<String>? = null

    private var trainingBatchSize: Output<String>? = null

    private var trainingCropSize: Output<String>? = null

    private var validationBatchSize: Output<String>? = null

    private var validationCropSize: Output<String>? = null

    private var validationResizeSize: Output<String>? = null

    private var warmupCosineLRCycles: Output<String>? = null

    private var warmupCosineLRWarmupEpochs: Output<String>? = null

    private var weightDecay: Output<String>? = null

    private var weightedLoss: Output<String>? = null

    /**
     * @param value Enable AMSGrad when optimizer is 'adam' or 'adamw'.
     */
    @JvmName("bbenlxidohgchrin")
    public suspend fun amsGradient(`value`: Output<String>) {
        this.amsGradient = value
    }

    /**
     * @param value Settings for using Augmentations.
     */
    @JvmName("ywyaqvemalwndjqv")
    public suspend fun augmentations(`value`: Output<String>) {
        this.augmentations = value
    }

    /**
     * @param value Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
     */
    @JvmName("ilbqrqvvpqdxgkua")
    public suspend fun beta1(`value`: Output<String>) {
        this.beta1 = value
    }

    /**
     * @param value Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
     */
    @JvmName("rvpulctdbaehcvha")
    public suspend fun beta2(`value`: Output<String>) {
        this.beta2 = value
    }

    /**
     * @param value Whether to use distributer training.
     */
    @JvmName("dedhlhfhccrxqmei")
    public suspend fun distributed(`value`: Output<String>) {
        this.distributed = value
    }

    /**
     * @param value Enable early stopping logic during training.
     */
    @JvmName("gdpdgmrsnehhribp")
    public suspend fun earlyStopping(`value`: Output<String>) {
        this.earlyStopping = value
    }

    /**
     * @param value Minimum number of epochs or validation evaluations to wait before primary metric improvement
     * is tracked for early stopping. Must be a positive integer.
     */
    @JvmName("hulhmmyavmqonuml")
    public suspend fun earlyStoppingDelay(`value`: Output<String>) {
        this.earlyStoppingDelay = value
    }

    /**
     * @param value Minimum number of epochs or validation evaluations with no primary metric improvement before
     * the run is stopped. Must be a positive integer.
     */
    @JvmName("ucihjwcxekpsoulq")
    public suspend fun earlyStoppingPatience(`value`: Output<String>) {
        this.earlyStoppingPatience = value
    }

    /**
     * @param value Enable normalization when exporting ONNX model.
     */
    @JvmName("cfvdafcptmmkbkrn")
    public suspend fun enableOnnxNormalization(`value`: Output<String>) {
        this.enableOnnxNormalization = value
    }

    /**
     * @param value Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
     */
    @JvmName("qqqjfmbyolmgvukh")
    public suspend fun evaluationFrequency(`value`: Output<String>) {
        this.evaluationFrequency = value
    }

    /**
     * @param value Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
     * updating the model weights while accumulating the gradients of those steps, and then using
     * the accumulated gradients to compute the weight updates. Must be a positive integer.
     */
    @JvmName("arxqxiypcptprdcm")
    public suspend fun gradientAccumulationStep(`value`: Output<String>) {
        this.gradientAccumulationStep = value
    }

    /**
     * @param value Number of layers to freeze for the model. Must be a positive integer.
     * For instance, passing 2 as value for 'seresnext' means
     * freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
     * see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
     */
    @JvmName("vnlonvaawtmycqld")
    public suspend fun layersToFreeze(`value`: Output<String>) {
        this.layersToFreeze = value
    }

    /**
     * @param value Initial learning rate. Must be a float in the range [0, 1].
     */
    @JvmName("sloyfdxjyyvhhwpj")
    public suspend fun learningRate(`value`: Output<String>) {
        this.learningRate = value
    }

    /**
     * @param value Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
     */
    @JvmName("kapnyretnlwljwrq")
    public suspend fun learningRateScheduler(`value`: Output<String>) {
        this.learningRateScheduler = value
    }

    /**
     * @param value Name of the model to use for training.
     * For more information on the available models please visit the official documentation:
     * https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
     */
    @JvmName("edvejyyywbdrouba")
    public suspend fun modelName(`value`: Output<String>) {
        this.modelName = value
    }

    /**
     * @param value Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
     */
    @JvmName("mujymfyydoapkdvn")
    public suspend fun momentum(`value`: Output<String>) {
        this.momentum = value
    }

    /**
     * @param value Enable nesterov when optimizer is 'sgd'.
     */
    @JvmName("sdbyvbsajjfvacrv")
    public suspend fun nesterov(`value`: Output<String>) {
        this.nesterov = value
    }

    /**
     * @param value Number of training epochs. Must be a positive integer.
     */
    @JvmName("xmhnlljccxrwnvoj")
    public suspend fun numberOfEpochs(`value`: Output<String>) {
        this.numberOfEpochs = value
    }

    /**
     * @param value Number of data loader workers. Must be a non-negative integer.
     */
    @JvmName("uqeqsqlvscsfcckq")
    public suspend fun numberOfWorkers(`value`: Output<String>) {
        this.numberOfWorkers = value
    }

    /**
     * @param value Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
     */
    @JvmName("qqiofjgsmokiwpff")
    public suspend fun optimizer(`value`: Output<String>) {
        this.optimizer = value
    }

    /**
     * @param value Random seed to be used when using deterministic training.
     */
    @JvmName("qokcitcqqvayxgll")
    public suspend fun randomSeed(`value`: Output<String>) {
        this.randomSeed = value
    }

    /**
     * @param value Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
     */
    @JvmName("sxxwvcleueewfsmj")
    public suspend fun stepLRGamma(`value`: Output<String>) {
        this.stepLRGamma = value
    }

    /**
     * @param value Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
     */
    @JvmName("bjbmhednvdhntsgf")
    public suspend fun stepLRStepSize(`value`: Output<String>) {
        this.stepLRStepSize = value
    }

    /**
     * @param value Training batch size. Must be a positive integer.
     */
    @JvmName("tfvvkqwvurilpxej")
    public suspend fun trainingBatchSize(`value`: Output<String>) {
        this.trainingBatchSize = value
    }

    /**
     * @param value Image crop size that is input to the neural network for the training dataset. Must be a positive integer.
     */
    @JvmName("ahtraqksngmdtcpf")
    public suspend fun trainingCropSize(`value`: Output<String>) {
        this.trainingCropSize = value
    }

    /**
     * @param value Validation batch size. Must be a positive integer.
     */
    @JvmName("cmsrlirtesuygsus")
    public suspend fun validationBatchSize(`value`: Output<String>) {
        this.validationBatchSize = value
    }

    /**
     * @param value Image crop size that is input to the neural network for the validation dataset. Must be a positive integer.
     */
    @JvmName("eqwhrnflvysbekxw")
    public suspend fun validationCropSize(`value`: Output<String>) {
        this.validationCropSize = value
    }

    /**
     * @param value Image size to which to resize before cropping for validation dataset. Must be a positive integer.
     */
    @JvmName("tpdnhkedlmgygmty")
    public suspend fun validationResizeSize(`value`: Output<String>) {
        this.validationResizeSize = value
    }

    /**
     * @param value Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
     */
    @JvmName("uppimhihjhbanndc")
    public suspend fun warmupCosineLRCycles(`value`: Output<String>) {
        this.warmupCosineLRCycles = value
    }

    /**
     * @param value Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
     */
    @JvmName("rcbjvomkhweinwfr")
    public suspend fun warmupCosineLRWarmupEpochs(`value`: Output<String>) {
        this.warmupCosineLRWarmupEpochs = value
    }

    /**
     * @param value Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
     */
    @JvmName("aukdjytkrumxiadn")
    public suspend fun weightDecay(`value`: Output<String>) {
        this.weightDecay = value
    }

    /**
     * @param value Weighted loss. The accepted values are 0 for no weighted loss.
     * 1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be 0 or 1 or 2.
     */
    @JvmName("tkjfyiminoftglmr")
    public suspend fun weightedLoss(`value`: Output<String>) {
        this.weightedLoss = value
    }

    /**
     * @param value Enable AMSGrad when optimizer is 'adam' or 'adamw'.
     */
    @JvmName("saoohudsldhausbs")
    public suspend fun amsGradient(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amsGradient = mapped
    }

    /**
     * @param value Settings for using Augmentations.
     */
    @JvmName("dsjpyneiekfrmahs")
    public suspend fun augmentations(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.augmentations = mapped
    }

    /**
     * @param value Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
     */
    @JvmName("erdrncrbfcddadcg")
    public suspend fun beta1(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.beta1 = mapped
    }

    /**
     * @param value Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
     */
    @JvmName("wlcjwydqpuxjehdp")
    public suspend fun beta2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.beta2 = mapped
    }

    /**
     * @param value Whether to use distributer training.
     */
    @JvmName("vhtlkynopbmiikbf")
    public suspend fun distributed(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distributed = mapped
    }

    /**
     * @param value Enable early stopping logic during training.
     */
    @JvmName("xbhlwostevuvastn")
    public suspend fun earlyStopping(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.earlyStopping = mapped
    }

    /**
     * @param value Minimum number of epochs or validation evaluations to wait before primary metric improvement
     * is tracked for early stopping. Must be a positive integer.
     */
    @JvmName("wcwdofcnytetuxjx")
    public suspend fun earlyStoppingDelay(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.earlyStoppingDelay = mapped
    }

    /**
     * @param value Minimum number of epochs or validation evaluations with no primary metric improvement before
     * the run is stopped. Must be a positive integer.
     */
    @JvmName("sqcdofxiwyhcukeh")
    public suspend fun earlyStoppingPatience(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.earlyStoppingPatience = mapped
    }

    /**
     * @param value Enable normalization when exporting ONNX model.
     */
    @JvmName("fsakdvxhhlqxuque")
    public suspend fun enableOnnxNormalization(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableOnnxNormalization = mapped
    }

    /**
     * @param value Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
     */
    @JvmName("dbbxsdxyjamcqfwj")
    public suspend fun evaluationFrequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evaluationFrequency = mapped
    }

    /**
     * @param value Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
     * updating the model weights while accumulating the gradients of those steps, and then using
     * the accumulated gradients to compute the weight updates. Must be a positive integer.
     */
    @JvmName("ftlfegvfosqqqwha")
    public suspend fun gradientAccumulationStep(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gradientAccumulationStep = mapped
    }

    /**
     * @param value Number of layers to freeze for the model. Must be a positive integer.
     * For instance, passing 2 as value for 'seresnext' means
     * freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
     * see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
     */
    @JvmName("kxtcmjlejxedivbq")
    public suspend fun layersToFreeze(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.layersToFreeze = mapped
    }

    /**
     * @param value Initial learning rate. Must be a float in the range [0, 1].
     */
    @JvmName("hxenyuxwwjisarey")
    public suspend fun learningRate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.learningRate = mapped
    }

    /**
     * @param value Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
     */
    @JvmName("qaavbvbglugqdrmx")
    public suspend fun learningRateScheduler(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.learningRateScheduler = mapped
    }

    /**
     * @param value Name of the model to use for training.
     * For more information on the available models please visit the official documentation:
     * https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
     */
    @JvmName("uowqrqrmbalnmbjp")
    public suspend fun modelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelName = mapped
    }

    /**
     * @param value Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
     */
    @JvmName("wtycbanybtshtjlw")
    public suspend fun momentum(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.momentum = mapped
    }

    /**
     * @param value Enable nesterov when optimizer is 'sgd'.
     */
    @JvmName("ahpgevpulcwgxkoa")
    public suspend fun nesterov(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nesterov = mapped
    }

    /**
     * @param value Number of training epochs. Must be a positive integer.
     */
    @JvmName("xhtnnvyqifmtowgy")
    public suspend fun numberOfEpochs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfEpochs = mapped
    }

    /**
     * @param value Number of data loader workers. Must be a non-negative integer.
     */
    @JvmName("nsqychdgfrrsnftu")
    public suspend fun numberOfWorkers(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfWorkers = mapped
    }

    /**
     * @param value Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
     */
    @JvmName("ufeovkscfancxsqg")
    public suspend fun optimizer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optimizer = mapped
    }

    /**
     * @param value Random seed to be used when using deterministic training.
     */
    @JvmName("yfdtulatrfgegmjk")
    public suspend fun randomSeed(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.randomSeed = mapped
    }

    /**
     * @param value Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
     */
    @JvmName("disgtttbpeudgmjn")
    public suspend fun stepLRGamma(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stepLRGamma = mapped
    }

    /**
     * @param value Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
     */
    @JvmName("rfibfrgbjqpiynjb")
    public suspend fun stepLRStepSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stepLRStepSize = mapped
    }

    /**
     * @param value Training batch size. Must be a positive integer.
     */
    @JvmName("asnbkxjquwmnamxo")
    public suspend fun trainingBatchSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trainingBatchSize = mapped
    }

    /**
     * @param value Image crop size that is input to the neural network for the training dataset. Must be a positive integer.
     */
    @JvmName("lceipxxtplmdgpqn")
    public suspend fun trainingCropSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trainingCropSize = mapped
    }

    /**
     * @param value Validation batch size. Must be a positive integer.
     */
    @JvmName("hyjvmcklwelirjsh")
    public suspend fun validationBatchSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationBatchSize = mapped
    }

    /**
     * @param value Image crop size that is input to the neural network for the validation dataset. Must be a positive integer.
     */
    @JvmName("tarqkjcgxbjcpkfs")
    public suspend fun validationCropSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationCropSize = mapped
    }

    /**
     * @param value Image size to which to resize before cropping for validation dataset. Must be a positive integer.
     */
    @JvmName("oqtpfcuthxgwmfbc")
    public suspend fun validationResizeSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationResizeSize = mapped
    }

    /**
     * @param value Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
     */
    @JvmName("vvmaouuoeuftijfx")
    public suspend fun warmupCosineLRCycles(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warmupCosineLRCycles = mapped
    }

    /**
     * @param value Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
     */
    @JvmName("whvvbelbhebnxkft")
    public suspend fun warmupCosineLRWarmupEpochs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warmupCosineLRWarmupEpochs = mapped
    }

    /**
     * @param value Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
     */
    @JvmName("jdbspwxgiynhdabw")
    public suspend fun weightDecay(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightDecay = mapped
    }

    /**
     * @param value Weighted loss. The accepted values are 0 for no weighted loss.
     * 1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be 0 or 1 or 2.
     */
    @JvmName("xgogvuxinnssuvrh")
    public suspend fun weightedLoss(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightedLoss = mapped
    }

    internal fun build(): ImageModelDistributionSettingsClassificationArgs =
        ImageModelDistributionSettingsClassificationArgs(
            amsGradient = amsGradient,
            augmentations = augmentations,
            beta1 = beta1,
            beta2 = beta2,
            distributed = distributed,
            earlyStopping = earlyStopping,
            earlyStoppingDelay = earlyStoppingDelay,
            earlyStoppingPatience = earlyStoppingPatience,
            enableOnnxNormalization = enableOnnxNormalization,
            evaluationFrequency = evaluationFrequency,
            gradientAccumulationStep = gradientAccumulationStep,
            layersToFreeze = layersToFreeze,
            learningRate = learningRate,
            learningRateScheduler = learningRateScheduler,
            modelName = modelName,
            momentum = momentum,
            nesterov = nesterov,
            numberOfEpochs = numberOfEpochs,
            numberOfWorkers = numberOfWorkers,
            optimizer = optimizer,
            randomSeed = randomSeed,
            stepLRGamma = stepLRGamma,
            stepLRStepSize = stepLRStepSize,
            trainingBatchSize = trainingBatchSize,
            trainingCropSize = trainingCropSize,
            validationBatchSize = validationBatchSize,
            validationCropSize = validationCropSize,
            validationResizeSize = validationResizeSize,
            warmupCosineLRCycles = warmupCosineLRCycles,
            warmupCosineLRWarmupEpochs = warmupCosineLRWarmupEpochs,
            weightDecay = weightDecay,
            weightedLoss = weightedLoss,
        )
}
