@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ImageModelSettingsObjectDetectionArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.LearningRateScheduler
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ModelSize
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.StochasticOptimizer
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ValidationMetricType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Settings used for training the model.
 * For more information on the available settings please visit the official documentation:
 * https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
 * @property advancedSettings Settings for advanced scenarios.
 * @property amsGradient Enable AMSGrad when optimizer is 'adam' or 'adamw'.
 * @property augmentations Settings for using Augmentations.
 * @property beta1 Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
 * @property beta2 Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
 * @property boxDetectionsPerImage Maximum number of detections per image, for all classes. Must be a positive integer.
 * Note: This settings is not supported for the 'yolov5' algorithm.
 * @property boxScoreThreshold During inference, only return proposals with a classification score greater than
 * BoxScoreThreshold. Must be a float in the range[0, 1].
 * @property checkpointFrequency Frequency to store model checkpoints. Must be a positive integer.
 * @property checkpointModel The pretrained checkpoint model for incremental training.
 * @property checkpointRunId The id of a previous run that has a pretrained checkpoint for incremental training.
 * @property distributed Whether to use distributed training.
 * @property earlyStopping Enable early stopping logic during training.
 * @property earlyStoppingDelay Minimum number of epochs or validation evaluations to wait before primary metric improvement
 * is tracked for early stopping. Must be a positive integer.
 * @property earlyStoppingPatience Minimum number of epochs or validation evaluations with no primary metric improvement before
 * the run is stopped. Must be a positive integer.
 * @property enableOnnxNormalization Enable normalization when exporting ONNX model.
 * @property evaluationFrequency Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
 * @property gradientAccumulationStep Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
 * updating the model weights while accumulating the gradients of those steps, and then using
 * the accumulated gradients to compute the weight updates. Must be a positive integer.
 * @property imageSize Image size for train and validation. Must be a positive integer.
 * Note: The training run may get into CUDA OOM if the size is too big.
 * Note: This settings is only supported for the 'yolov5' algorithm.
 * @property layersToFreeze Number of layers to freeze for the model. Must be a positive integer.
 * For instance, passing 2 as value for 'seresnext' means
 * freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
 * see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
 * @property learningRate Initial learning rate. Must be a float in the range [0, 1].
 * @property learningRateScheduler Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
 * @property maxSize Maximum size of the image to be rescaled before feeding it to the backbone.
 * Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
 * Note: This settings is not supported for the 'yolov5' algorithm.
 * @property minSize Minimum size of the image to be rescaled before feeding it to the backbone.
 * Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
 * Note: This settings is not supported for the 'yolov5' algorithm.
 * @property modelName Name of the model to use for training.
 * For more information on the available models please visit the official documentation:
 * https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
 * @property modelSize Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
 * Note: training run may get into CUDA OOM if the model size is too big.
 * Note: This settings is only supported for the 'yolov5' algorithm.
 * @property momentum Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
 * @property multiScale Enable multi-scale image by varying image size by +/- 50%.
 * Note: training run may get into CUDA OOM if no sufficient GPU memory.
 * Note: This settings is only supported for the 'yolov5' algorithm.
 * @property nesterov Enable nesterov when optimizer is 'sgd'.
 * @property nmsIouThreshold IOU threshold used during inference in NMS post processing. Must be a float in the range [0, 1].
 * @property numberOfEpochs Number of training epochs. Must be a positive integer.
 * @property numberOfWorkers Number of data loader workers. Must be a non-negative integer.
 * @property optimizer Type of optimizer.
 * @property randomSeed Random seed to be used when using deterministic training.
 * @property stepLRGamma Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
 * @property stepLRStepSize Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
 * @property tileGridSize The grid size to use for tiling each image. Note: TileGridSize must not be
 * None to enable small object detection logic. A string containing two integers in mxn format.
 * Note: This settings is not supported for the 'yolov5' algorithm.
 * @property tileOverlapRatio Overlap ratio between adjacent tiles in each dimension. Must be float in the range [0, 1).
 * Note: This settings is not supported for the 'yolov5' algorithm.
 * @property tilePredictionsNmsThreshold The IOU threshold to use to perform NMS while merging predictions from tiles and image.
 * Used in validation/ inference. Must be float in the range [0, 1].
 * Note: This settings is not supported for the 'yolov5' algorithm.
 * @property trainingBatchSize Training batch size. Must be a positive integer.
 * @property validationBatchSize Validation batch size. Must be a positive integer.
 * @property validationIouThreshold IOU threshold to use when computing validation metric. Must be float in the range [0, 1].
 * @property validationMetricType Metric computation method to use for validation metrics.
 * @property warmupCosineLRCycles Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
 * @property warmupCosineLRWarmupEpochs Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
 * @property weightDecay Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
 */
public data class ImageModelSettingsObjectDetectionArgs(
    public val advancedSettings: Output<String>? = null,
    public val amsGradient: Output<Boolean>? = null,
    public val augmentations: Output<String>? = null,
    public val beta1: Output<Double>? = null,
    public val beta2: Output<Double>? = null,
    public val boxDetectionsPerImage: Output<Int>? = null,
    public val boxScoreThreshold: Output<Double>? = null,
    public val checkpointFrequency: Output<Int>? = null,
    public val checkpointModel: Output<MLFlowModelJobInputArgs>? = null,
    public val checkpointRunId: Output<String>? = null,
    public val distributed: Output<Boolean>? = null,
    public val earlyStopping: Output<Boolean>? = null,
    public val earlyStoppingDelay: Output<Int>? = null,
    public val earlyStoppingPatience: Output<Int>? = null,
    public val enableOnnxNormalization: Output<Boolean>? = null,
    public val evaluationFrequency: Output<Int>? = null,
    public val gradientAccumulationStep: Output<Int>? = null,
    public val imageSize: Output<Int>? = null,
    public val layersToFreeze: Output<Int>? = null,
    public val learningRate: Output<Double>? = null,
    public val learningRateScheduler: Output<Either<String, LearningRateScheduler>>? = null,
    public val maxSize: Output<Int>? = null,
    public val minSize: Output<Int>? = null,
    public val modelName: Output<String>? = null,
    public val modelSize: Output<Either<String, ModelSize>>? = null,
    public val momentum: Output<Double>? = null,
    public val multiScale: Output<Boolean>? = null,
    public val nesterov: Output<Boolean>? = null,
    public val nmsIouThreshold: Output<Double>? = null,
    public val numberOfEpochs: Output<Int>? = null,
    public val numberOfWorkers: Output<Int>? = null,
    public val optimizer: Output<Either<String, StochasticOptimizer>>? = null,
    public val randomSeed: Output<Int>? = null,
    public val stepLRGamma: Output<Double>? = null,
    public val stepLRStepSize: Output<Int>? = null,
    public val tileGridSize: Output<String>? = null,
    public val tileOverlapRatio: Output<Double>? = null,
    public val tilePredictionsNmsThreshold: Output<Double>? = null,
    public val trainingBatchSize: Output<Int>? = null,
    public val validationBatchSize: Output<Int>? = null,
    public val validationIouThreshold: Output<Double>? = null,
    public val validationMetricType: Output<Either<String, ValidationMetricType>>? = null,
    public val warmupCosineLRCycles: Output<Double>? = null,
    public val warmupCosineLRWarmupEpochs: Output<Int>? = null,
    public val weightDecay: Output<Double>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ImageModelSettingsObjectDetectionArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.ImageModelSettingsObjectDetectionArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ImageModelSettingsObjectDetectionArgs.builder()
            .advancedSettings(advancedSettings?.applyValue({ args0 -> args0 }))
            .amsGradient(amsGradient?.applyValue({ args0 -> args0 }))
            .augmentations(augmentations?.applyValue({ args0 -> args0 }))
            .beta1(beta1?.applyValue({ args0 -> args0 }))
            .beta2(beta2?.applyValue({ args0 -> args0 }))
            .boxDetectionsPerImage(boxDetectionsPerImage?.applyValue({ args0 -> args0 }))
            .boxScoreThreshold(boxScoreThreshold?.applyValue({ args0 -> args0 }))
            .checkpointFrequency(checkpointFrequency?.applyValue({ args0 -> args0 }))
            .checkpointModel(checkpointModel?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .checkpointRunId(checkpointRunId?.applyValue({ args0 -> args0 }))
            .distributed(distributed?.applyValue({ args0 -> args0 }))
            .earlyStopping(earlyStopping?.applyValue({ args0 -> args0 }))
            .earlyStoppingDelay(earlyStoppingDelay?.applyValue({ args0 -> args0 }))
            .earlyStoppingPatience(earlyStoppingPatience?.applyValue({ args0 -> args0 }))
            .enableOnnxNormalization(enableOnnxNormalization?.applyValue({ args0 -> args0 }))
            .evaluationFrequency(evaluationFrequency?.applyValue({ args0 -> args0 }))
            .gradientAccumulationStep(gradientAccumulationStep?.applyValue({ args0 -> args0 }))
            .imageSize(imageSize?.applyValue({ args0 -> args0 }))
            .layersToFreeze(layersToFreeze?.applyValue({ args0 -> args0 }))
            .learningRate(learningRate?.applyValue({ args0 -> args0 }))
            .learningRateScheduler(
                learningRateScheduler?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .maxSize(maxSize?.applyValue({ args0 -> args0 }))
            .minSize(minSize?.applyValue({ args0 -> args0 }))
            .modelName(modelName?.applyValue({ args0 -> args0 }))
            .modelSize(
                modelSize?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .momentum(momentum?.applyValue({ args0 -> args0 }))
            .multiScale(multiScale?.applyValue({ args0 -> args0 }))
            .nesterov(nesterov?.applyValue({ args0 -> args0 }))
            .nmsIouThreshold(nmsIouThreshold?.applyValue({ args0 -> args0 }))
            .numberOfEpochs(numberOfEpochs?.applyValue({ args0 -> args0 }))
            .numberOfWorkers(numberOfWorkers?.applyValue({ args0 -> args0 }))
            .optimizer(
                optimizer?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .randomSeed(randomSeed?.applyValue({ args0 -> args0 }))
            .stepLRGamma(stepLRGamma?.applyValue({ args0 -> args0 }))
            .stepLRStepSize(stepLRStepSize?.applyValue({ args0 -> args0 }))
            .tileGridSize(tileGridSize?.applyValue({ args0 -> args0 }))
            .tileOverlapRatio(tileOverlapRatio?.applyValue({ args0 -> args0 }))
            .tilePredictionsNmsThreshold(tilePredictionsNmsThreshold?.applyValue({ args0 -> args0 }))
            .trainingBatchSize(trainingBatchSize?.applyValue({ args0 -> args0 }))
            .validationBatchSize(validationBatchSize?.applyValue({ args0 -> args0 }))
            .validationIouThreshold(validationIouThreshold?.applyValue({ args0 -> args0 }))
            .validationMetricType(
                validationMetricType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .warmupCosineLRCycles(warmupCosineLRCycles?.applyValue({ args0 -> args0 }))
            .warmupCosineLRWarmupEpochs(warmupCosineLRWarmupEpochs?.applyValue({ args0 -> args0 }))
            .weightDecay(weightDecay?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageModelSettingsObjectDetectionArgs].
 */
@PulumiTagMarker
public class ImageModelSettingsObjectDetectionArgsBuilder internal constructor() {
    private var advancedSettings: Output<String>? = null

    private var amsGradient: Output<Boolean>? = null

    private var augmentations: Output<String>? = null

    private var beta1: Output<Double>? = null

    private var beta2: Output<Double>? = null

    private var boxDetectionsPerImage: Output<Int>? = null

    private var boxScoreThreshold: Output<Double>? = null

    private var checkpointFrequency: Output<Int>? = null

    private var checkpointModel: Output<MLFlowModelJobInputArgs>? = null

    private var checkpointRunId: Output<String>? = null

    private var distributed: Output<Boolean>? = null

    private var earlyStopping: Output<Boolean>? = null

    private var earlyStoppingDelay: Output<Int>? = null

    private var earlyStoppingPatience: Output<Int>? = null

    private var enableOnnxNormalization: Output<Boolean>? = null

    private var evaluationFrequency: Output<Int>? = null

    private var gradientAccumulationStep: Output<Int>? = null

    private var imageSize: Output<Int>? = null

    private var layersToFreeze: Output<Int>? = null

    private var learningRate: Output<Double>? = null

    private var learningRateScheduler: Output<Either<String, LearningRateScheduler>>? = null

    private var maxSize: Output<Int>? = null

    private var minSize: Output<Int>? = null

    private var modelName: Output<String>? = null

    private var modelSize: Output<Either<String, ModelSize>>? = null

    private var momentum: Output<Double>? = null

    private var multiScale: Output<Boolean>? = null

    private var nesterov: Output<Boolean>? = null

    private var nmsIouThreshold: Output<Double>? = null

    private var numberOfEpochs: Output<Int>? = null

    private var numberOfWorkers: Output<Int>? = null

    private var optimizer: Output<Either<String, StochasticOptimizer>>? = null

    private var randomSeed: Output<Int>? = null

    private var stepLRGamma: Output<Double>? = null

    private var stepLRStepSize: Output<Int>? = null

    private var tileGridSize: Output<String>? = null

    private var tileOverlapRatio: Output<Double>? = null

    private var tilePredictionsNmsThreshold: Output<Double>? = null

    private var trainingBatchSize: Output<Int>? = null

    private var validationBatchSize: Output<Int>? = null

    private var validationIouThreshold: Output<Double>? = null

    private var validationMetricType: Output<Either<String, ValidationMetricType>>? = null

    private var warmupCosineLRCycles: Output<Double>? = null

    private var warmupCosineLRWarmupEpochs: Output<Int>? = null

    private var weightDecay: Output<Double>? = null

    /**
     * @param value Settings for advanced scenarios.
     */
    @JvmName("fidaihxylfdehnfh")
    public suspend fun advancedSettings(`value`: Output<String>) {
        this.advancedSettings = value
    }

    /**
     * @param value Enable AMSGrad when optimizer is 'adam' or 'adamw'.
     */
    @JvmName("gnmmujqdkmxtorrb")
    public suspend fun amsGradient(`value`: Output<Boolean>) {
        this.amsGradient = value
    }

    /**
     * @param value Settings for using Augmentations.
     */
    @JvmName("urocwwwkekbujesa")
    public suspend fun augmentations(`value`: Output<String>) {
        this.augmentations = value
    }

    /**
     * @param value Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
     */
    @JvmName("qojcsqcuxgavwput")
    public suspend fun beta1(`value`: Output<Double>) {
        this.beta1 = value
    }

    /**
     * @param value Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
     */
    @JvmName("yaolhiwyrejijgvp")
    public suspend fun beta2(`value`: Output<Double>) {
        this.beta2 = value
    }

    /**
     * @param value Maximum number of detections per image, for all classes. Must be a positive integer.
     * Note: This settings is not supported for the 'yolov5' algorithm.
     */
    @JvmName("bhremafvrdeyshfm")
    public suspend fun boxDetectionsPerImage(`value`: Output<Int>) {
        this.boxDetectionsPerImage = value
    }

    /**
     * @param value During inference, only return proposals with a classification score greater than
     * BoxScoreThreshold. Must be a float in the range[0, 1].
     */
    @JvmName("bxhbqgnvhuopxlub")
    public suspend fun boxScoreThreshold(`value`: Output<Double>) {
        this.boxScoreThreshold = value
    }

    /**
     * @param value Frequency to store model checkpoints. Must be a positive integer.
     */
    @JvmName("wdifymcnwjtktnil")
    public suspend fun checkpointFrequency(`value`: Output<Int>) {
        this.checkpointFrequency = value
    }

    /**
     * @param value The pretrained checkpoint model for incremental training.
     */
    @JvmName("gvuikjggbyfcfqkj")
    public suspend fun checkpointModel(`value`: Output<MLFlowModelJobInputArgs>) {
        this.checkpointModel = value
    }

    /**
     * @param value The id of a previous run that has a pretrained checkpoint for incremental training.
     */
    @JvmName("ewgpukqxdmwcfkny")
    public suspend fun checkpointRunId(`value`: Output<String>) {
        this.checkpointRunId = value
    }

    /**
     * @param value Whether to use distributed training.
     */
    @JvmName("lgpuusrutwfcbdid")
    public suspend fun distributed(`value`: Output<Boolean>) {
        this.distributed = value
    }

    /**
     * @param value Enable early stopping logic during training.
     */
    @JvmName("uxegpbwrtwdelbbn")
    public suspend fun earlyStopping(`value`: Output<Boolean>) {
        this.earlyStopping = value
    }

    /**
     * @param value Minimum number of epochs or validation evaluations to wait before primary metric improvement
     * is tracked for early stopping. Must be a positive integer.
     */
    @JvmName("dwxwdpttgftyends")
    public suspend fun earlyStoppingDelay(`value`: Output<Int>) {
        this.earlyStoppingDelay = value
    }

    /**
     * @param value Minimum number of epochs or validation evaluations with no primary metric improvement before
     * the run is stopped. Must be a positive integer.
     */
    @JvmName("gqxvpoabtwvwybki")
    public suspend fun earlyStoppingPatience(`value`: Output<Int>) {
        this.earlyStoppingPatience = value
    }

    /**
     * @param value Enable normalization when exporting ONNX model.
     */
    @JvmName("piwkugpcelyifutr")
    public suspend fun enableOnnxNormalization(`value`: Output<Boolean>) {
        this.enableOnnxNormalization = value
    }

    /**
     * @param value Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
     */
    @JvmName("xhxxtvjxyrtcthvg")
    public suspend fun evaluationFrequency(`value`: Output<Int>) {
        this.evaluationFrequency = value
    }

    /**
     * @param value Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
     * updating the model weights while accumulating the gradients of those steps, and then using
     * the accumulated gradients to compute the weight updates. Must be a positive integer.
     */
    @JvmName("fjpcfhevnrvirsut")
    public suspend fun gradientAccumulationStep(`value`: Output<Int>) {
        this.gradientAccumulationStep = value
    }

    /**
     * @param value Image size for train and validation. Must be a positive integer.
     * Note: The training run may get into CUDA OOM if the size is too big.
     * Note: This settings is only supported for the 'yolov5' algorithm.
     */
    @JvmName("ehimagjqwwleawdn")
    public suspend fun imageSize(`value`: Output<Int>) {
        this.imageSize = value
    }

    /**
     * @param value Number of layers to freeze for the model. Must be a positive integer.
     * For instance, passing 2 as value for 'seresnext' means
     * freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
     * see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
     */
    @JvmName("tkrjymnqhfkxbepl")
    public suspend fun layersToFreeze(`value`: Output<Int>) {
        this.layersToFreeze = value
    }

    /**
     * @param value Initial learning rate. Must be a float in the range [0, 1].
     */
    @JvmName("jajknualadstupyq")
    public suspend fun learningRate(`value`: Output<Double>) {
        this.learningRate = value
    }

    /**
     * @param value Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
     */
    @JvmName("istedryxaonyiaow")
    public suspend fun learningRateScheduler(`value`: Output<Either<String, LearningRateScheduler>>) {
        this.learningRateScheduler = value
    }

    /**
     * @param value Maximum size of the image to be rescaled before feeding it to the backbone.
     * Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     * Note: This settings is not supported for the 'yolov5' algorithm.
     */
    @JvmName("ocpnddbqnutnpppb")
    public suspend fun maxSize(`value`: Output<Int>) {
        this.maxSize = value
    }

    /**
     * @param value Minimum size of the image to be rescaled before feeding it to the backbone.
     * Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     * Note: This settings is not supported for the 'yolov5' algorithm.
     */
    @JvmName("xendqlvaynjclcdl")
    public suspend fun minSize(`value`: Output<Int>) {
        this.minSize = value
    }

    /**
     * @param value Name of the model to use for training.
     * For more information on the available models please visit the official documentation:
     * https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
     */
    @JvmName("jyijylwmomkxpdkh")
    public suspend fun modelName(`value`: Output<String>) {
        this.modelName = value
    }

    /**
     * @param value Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
     * Note: training run may get into CUDA OOM if the model size is too big.
     * Note: This settings is only supported for the 'yolov5' algorithm.
     */
    @JvmName("taydtwtxikjftrlw")
    public suspend fun modelSize(`value`: Output<Either<String, ModelSize>>) {
        this.modelSize = value
    }

    /**
     * @param value Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
     */
    @JvmName("fdleykowjrfahklt")
    public suspend fun momentum(`value`: Output<Double>) {
        this.momentum = value
    }

    /**
     * @param value Enable multi-scale image by varying image size by +/- 50%.
     * Note: training run may get into CUDA OOM if no sufficient GPU memory.
     * Note: This settings is only supported for the 'yolov5' algorithm.
     */
    @JvmName("urvltqnetfinsojw")
    public suspend fun multiScale(`value`: Output<Boolean>) {
        this.multiScale = value
    }

    /**
     * @param value Enable nesterov when optimizer is 'sgd'.
     */
    @JvmName("bvfrnlebttvpduil")
    public suspend fun nesterov(`value`: Output<Boolean>) {
        this.nesterov = value
    }

    /**
     * @param value IOU threshold used during inference in NMS post processing. Must be a float in the range [0, 1].
     */
    @JvmName("vlymoirdpmgpvpmh")
    public suspend fun nmsIouThreshold(`value`: Output<Double>) {
        this.nmsIouThreshold = value
    }

    /**
     * @param value Number of training epochs. Must be a positive integer.
     */
    @JvmName("wexhjgbrbcoslcnd")
    public suspend fun numberOfEpochs(`value`: Output<Int>) {
        this.numberOfEpochs = value
    }

    /**
     * @param value Number of data loader workers. Must be a non-negative integer.
     */
    @JvmName("sryyunlyaquiitfx")
    public suspend fun numberOfWorkers(`value`: Output<Int>) {
        this.numberOfWorkers = value
    }

    /**
     * @param value Type of optimizer.
     */
    @JvmName("louceuunnjfmsodr")
    public suspend fun optimizer(`value`: Output<Either<String, StochasticOptimizer>>) {
        this.optimizer = value
    }

    /**
     * @param value Random seed to be used when using deterministic training.
     */
    @JvmName("yufiwvyxqshahdjl")
    public suspend fun randomSeed(`value`: Output<Int>) {
        this.randomSeed = value
    }

    /**
     * @param value Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
     */
    @JvmName("uyknqcmtrbvwnien")
    public suspend fun stepLRGamma(`value`: Output<Double>) {
        this.stepLRGamma = value
    }

    /**
     * @param value Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
     */
    @JvmName("jrqpdcrykwdambvq")
    public suspend fun stepLRStepSize(`value`: Output<Int>) {
        this.stepLRStepSize = value
    }

    /**
     * @param value The grid size to use for tiling each image. Note: TileGridSize must not be
     * None to enable small object detection logic. A string containing two integers in mxn format.
     * Note: This settings is not supported for the 'yolov5' algorithm.
     */
    @JvmName("risqeliexynvinnp")
    public suspend fun tileGridSize(`value`: Output<String>) {
        this.tileGridSize = value
    }

    /**
     * @param value Overlap ratio between adjacent tiles in each dimension. Must be float in the range [0, 1).
     * Note: This settings is not supported for the 'yolov5' algorithm.
     */
    @JvmName("lfqpiwrjpsmbgfbk")
    public suspend fun tileOverlapRatio(`value`: Output<Double>) {
        this.tileOverlapRatio = value
    }

    /**
     * @param value The IOU threshold to use to perform NMS while merging predictions from tiles and image.
     * Used in validation/ inference. Must be float in the range [0, 1].
     * Note: This settings is not supported for the 'yolov5' algorithm.
     */
    @JvmName("jqtlibqcjqeusqon")
    public suspend fun tilePredictionsNmsThreshold(`value`: Output<Double>) {
        this.tilePredictionsNmsThreshold = value
    }

    /**
     * @param value Training batch size. Must be a positive integer.
     */
    @JvmName("ragsaoclghapcplo")
    public suspend fun trainingBatchSize(`value`: Output<Int>) {
        this.trainingBatchSize = value
    }

    /**
     * @param value Validation batch size. Must be a positive integer.
     */
    @JvmName("ppvtpowqofnilqgq")
    public suspend fun validationBatchSize(`value`: Output<Int>) {
        this.validationBatchSize = value
    }

    /**
     * @param value IOU threshold to use when computing validation metric. Must be float in the range [0, 1].
     */
    @JvmName("dvlnrmqdbhxewgiu")
    public suspend fun validationIouThreshold(`value`: Output<Double>) {
        this.validationIouThreshold = value
    }

    /**
     * @param value Metric computation method to use for validation metrics.
     */
    @JvmName("eyadocwrtjpbpgsg")
    public suspend fun validationMetricType(`value`: Output<Either<String, ValidationMetricType>>) {
        this.validationMetricType = value
    }

    /**
     * @param value Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
     */
    @JvmName("doqrbwkdqygcmrie")
    public suspend fun warmupCosineLRCycles(`value`: Output<Double>) {
        this.warmupCosineLRCycles = value
    }

    /**
     * @param value Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
     */
    @JvmName("nnghrrsicepkeqtw")
    public suspend fun warmupCosineLRWarmupEpochs(`value`: Output<Int>) {
        this.warmupCosineLRWarmupEpochs = value
    }

    /**
     * @param value Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
     */
    @JvmName("jxoallasbdgrhlsd")
    public suspend fun weightDecay(`value`: Output<Double>) {
        this.weightDecay = value
    }

    /**
     * @param value Settings for advanced scenarios.
     */
    @JvmName("odhdyighionidste")
    public suspend fun advancedSettings(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advancedSettings = mapped
    }

    /**
     * @param value Enable AMSGrad when optimizer is 'adam' or 'adamw'.
     */
    @JvmName("cgplfluekbafhgrh")
    public suspend fun amsGradient(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amsGradient = mapped
    }

    /**
     * @param value Settings for using Augmentations.
     */
    @JvmName("laoenivhkpcpmqfo")
    public suspend fun augmentations(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.augmentations = mapped
    }

    /**
     * @param value Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
     */
    @JvmName("kvtecdogglgrchld")
    public suspend fun beta1(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.beta1 = mapped
    }

    /**
     * @param value Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
     */
    @JvmName("huasooawiepjtwkm")
    public suspend fun beta2(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.beta2 = mapped
    }

    /**
     * @param value Maximum number of detections per image, for all classes. Must be a positive integer.
     * Note: This settings is not supported for the 'yolov5' algorithm.
     */
    @JvmName("mvjuiscslkygrtaq")
    public suspend fun boxDetectionsPerImage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.boxDetectionsPerImage = mapped
    }

    /**
     * @param value During inference, only return proposals with a classification score greater than
     * BoxScoreThreshold. Must be a float in the range[0, 1].
     */
    @JvmName("prsfxdvvggeqhvhy")
    public suspend fun boxScoreThreshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.boxScoreThreshold = mapped
    }

    /**
     * @param value Frequency to store model checkpoints. Must be a positive integer.
     */
    @JvmName("tmfnpmuoychqhakr")
    public suspend fun checkpointFrequency(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkpointFrequency = mapped
    }

    /**
     * @param value The pretrained checkpoint model for incremental training.
     */
    @JvmName("edlkwgvdnjulryng")
    public suspend fun checkpointModel(`value`: MLFlowModelJobInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkpointModel = mapped
    }

    /**
     * @param argument The pretrained checkpoint model for incremental training.
     */
    @JvmName("uupcsaehrvkidpuf")
    public suspend fun checkpointModel(argument: suspend MLFlowModelJobInputArgsBuilder.() -> Unit) {
        val toBeMapped = MLFlowModelJobInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.checkpointModel = mapped
    }

    /**
     * @param value The id of a previous run that has a pretrained checkpoint for incremental training.
     */
    @JvmName("bkbibgbrpqsvdcpo")
    public suspend fun checkpointRunId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkpointRunId = mapped
    }

    /**
     * @param value Whether to use distributed training.
     */
    @JvmName("jggftstnfarrxwva")
    public suspend fun distributed(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distributed = mapped
    }

    /**
     * @param value Enable early stopping logic during training.
     */
    @JvmName("nhjlcajvwrqlkmeb")
    public suspend fun earlyStopping(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.earlyStopping = mapped
    }

    /**
     * @param value Minimum number of epochs or validation evaluations to wait before primary metric improvement
     * is tracked for early stopping. Must be a positive integer.
     */
    @JvmName("xnitjdarlkmpmptd")
    public suspend fun earlyStoppingDelay(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.earlyStoppingDelay = mapped
    }

    /**
     * @param value Minimum number of epochs or validation evaluations with no primary metric improvement before
     * the run is stopped. Must be a positive integer.
     */
    @JvmName("wagwvhegxnimhroc")
    public suspend fun earlyStoppingPatience(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.earlyStoppingPatience = mapped
    }

    /**
     * @param value Enable normalization when exporting ONNX model.
     */
    @JvmName("hlxhgtdeufcfcjfy")
    public suspend fun enableOnnxNormalization(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableOnnxNormalization = mapped
    }

    /**
     * @param value Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
     */
    @JvmName("xxnpykauseqbvnhr")
    public suspend fun evaluationFrequency(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evaluationFrequency = mapped
    }

    /**
     * @param value Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
     * updating the model weights while accumulating the gradients of those steps, and then using
     * the accumulated gradients to compute the weight updates. Must be a positive integer.
     */
    @JvmName("eairhvaodugwqufa")
    public suspend fun gradientAccumulationStep(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gradientAccumulationStep = mapped
    }

    /**
     * @param value Image size for train and validation. Must be a positive integer.
     * Note: The training run may get into CUDA OOM if the size is too big.
     * Note: This settings is only supported for the 'yolov5' algorithm.
     */
    @JvmName("gadoegoqsmrqmjiu")
    public suspend fun imageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageSize = mapped
    }

    /**
     * @param value Number of layers to freeze for the model. Must be a positive integer.
     * For instance, passing 2 as value for 'seresnext' means
     * freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
     * see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
     */
    @JvmName("hmkhuamoxyweedww")
    public suspend fun layersToFreeze(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.layersToFreeze = mapped
    }

    /**
     * @param value Initial learning rate. Must be a float in the range [0, 1].
     */
    @JvmName("hwxrxopnvodppxtb")
    public suspend fun learningRate(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.learningRate = mapped
    }

    /**
     * @param value Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
     */
    @JvmName("gmqrpxemrseypfxi")
    public suspend fun learningRateScheduler(`value`: Either<String, LearningRateScheduler>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.learningRateScheduler = mapped
    }

    /**
     * @param value Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
     */
    @JvmName("hdqmhlijcfrltnbu")
    public fun learningRateScheduler(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LearningRateScheduler>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.learningRateScheduler = mapped
    }

    /**
     * @param value Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
     */
    @JvmName("kmayfnrbooylhdcg")
    public fun learningRateScheduler(`value`: LearningRateScheduler) {
        val toBeMapped = Either.ofRight<String, LearningRateScheduler>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.learningRateScheduler = mapped
    }

    /**
     * @param value Maximum size of the image to be rescaled before feeding it to the backbone.
     * Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     * Note: This settings is not supported for the 'yolov5' algorithm.
     */
    @JvmName("iwxssqeovorpkaja")
    public suspend fun maxSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxSize = mapped
    }

    /**
     * @param value Minimum size of the image to be rescaled before feeding it to the backbone.
     * Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     * Note: This settings is not supported for the 'yolov5' algorithm.
     */
    @JvmName("vxrsplmhqqqkrujd")
    public suspend fun minSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minSize = mapped
    }

    /**
     * @param value Name of the model to use for training.
     * For more information on the available models please visit the official documentation:
     * https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
     */
    @JvmName("dawpsjbprwvkrviq")
    public suspend fun modelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelName = mapped
    }

    /**
     * @param value Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
     * Note: training run may get into CUDA OOM if the model size is too big.
     * Note: This settings is only supported for the 'yolov5' algorithm.
     */
    @JvmName("qnajnvvqycgdvwbq")
    public suspend fun modelSize(`value`: Either<String, ModelSize>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelSize = mapped
    }

    /**
     * @param value Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
     * Note: training run may get into CUDA OOM if the model size is too big.
     * Note: This settings is only supported for the 'yolov5' algorithm.
     */
    @JvmName("ahqynkpgenfrcunb")
    public fun modelSize(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ModelSize>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.modelSize = mapped
    }

    /**
     * @param value Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
     * Note: training run may get into CUDA OOM if the model size is too big.
     * Note: This settings is only supported for the 'yolov5' algorithm.
     */
    @JvmName("gdkpmclsymbwmwuj")
    public fun modelSize(`value`: ModelSize) {
        val toBeMapped = Either.ofRight<String, ModelSize>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.modelSize = mapped
    }

    /**
     * @param value Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
     */
    @JvmName("yiyxeeulrnnuljcj")
    public suspend fun momentum(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.momentum = mapped
    }

    /**
     * @param value Enable multi-scale image by varying image size by +/- 50%.
     * Note: training run may get into CUDA OOM if no sufficient GPU memory.
     * Note: This settings is only supported for the 'yolov5' algorithm.
     */
    @JvmName("oqfbpcbyiwcgpxqp")
    public suspend fun multiScale(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiScale = mapped
    }

    /**
     * @param value Enable nesterov when optimizer is 'sgd'.
     */
    @JvmName("lrcmauqrtjgmbggw")
    public suspend fun nesterov(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nesterov = mapped
    }

    /**
     * @param value IOU threshold used during inference in NMS post processing. Must be a float in the range [0, 1].
     */
    @JvmName("cpyifwqyosmqlrvv")
    public suspend fun nmsIouThreshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nmsIouThreshold = mapped
    }

    /**
     * @param value Number of training epochs. Must be a positive integer.
     */
    @JvmName("pyymdaauoweosqmj")
    public suspend fun numberOfEpochs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfEpochs = mapped
    }

    /**
     * @param value Number of data loader workers. Must be a non-negative integer.
     */
    @JvmName("lhgcxbiomeghewiw")
    public suspend fun numberOfWorkers(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfWorkers = mapped
    }

    /**
     * @param value Type of optimizer.
     */
    @JvmName("ocyrsbhrumofhfgd")
    public suspend fun optimizer(`value`: Either<String, StochasticOptimizer>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optimizer = mapped
    }

    /**
     * @param value Type of optimizer.
     */
    @JvmName("vyqqstvnacbkhidt")
    public fun optimizer(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StochasticOptimizer>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.optimizer = mapped
    }

    /**
     * @param value Type of optimizer.
     */
    @JvmName("ldqrcknyhdidtaar")
    public fun optimizer(`value`: StochasticOptimizer) {
        val toBeMapped = Either.ofRight<String, StochasticOptimizer>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.optimizer = mapped
    }

    /**
     * @param value Random seed to be used when using deterministic training.
     */
    @JvmName("lsdrofydyfdvbutk")
    public suspend fun randomSeed(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.randomSeed = mapped
    }

    /**
     * @param value Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
     */
    @JvmName("egmswsotvphxqynd")
    public suspend fun stepLRGamma(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stepLRGamma = mapped
    }

    /**
     * @param value Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
     */
    @JvmName("ldoxothiujyctinm")
    public suspend fun stepLRStepSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stepLRStepSize = mapped
    }

    /**
     * @param value The grid size to use for tiling each image. Note: TileGridSize must not be
     * None to enable small object detection logic. A string containing two integers in mxn format.
     * Note: This settings is not supported for the 'yolov5' algorithm.
     */
    @JvmName("iistmnwbykpiryll")
    public suspend fun tileGridSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tileGridSize = mapped
    }

    /**
     * @param value Overlap ratio between adjacent tiles in each dimension. Must be float in the range [0, 1).
     * Note: This settings is not supported for the 'yolov5' algorithm.
     */
    @JvmName("idqjmisfoqcolkap")
    public suspend fun tileOverlapRatio(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tileOverlapRatio = mapped
    }

    /**
     * @param value The IOU threshold to use to perform NMS while merging predictions from tiles and image.
     * Used in validation/ inference. Must be float in the range [0, 1].
     * Note: This settings is not supported for the 'yolov5' algorithm.
     */
    @JvmName("cmprgqtdiscomyix")
    public suspend fun tilePredictionsNmsThreshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tilePredictionsNmsThreshold = mapped
    }

    /**
     * @param value Training batch size. Must be a positive integer.
     */
    @JvmName("scliybmwplrbqrro")
    public suspend fun trainingBatchSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trainingBatchSize = mapped
    }

    /**
     * @param value Validation batch size. Must be a positive integer.
     */
    @JvmName("qcdvoxvitileapfk")
    public suspend fun validationBatchSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationBatchSize = mapped
    }

    /**
     * @param value IOU threshold to use when computing validation metric. Must be float in the range [0, 1].
     */
    @JvmName("angjjkaslbufpkoc")
    public suspend fun validationIouThreshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationIouThreshold = mapped
    }

    /**
     * @param value Metric computation method to use for validation metrics.
     */
    @JvmName("tiijgmwmawicryah")
    public suspend fun validationMetricType(`value`: Either<String, ValidationMetricType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationMetricType = mapped
    }

    /**
     * @param value Metric computation method to use for validation metrics.
     */
    @JvmName("fwtsuuonutiaraca")
    public fun validationMetricType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ValidationMetricType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validationMetricType = mapped
    }

    /**
     * @param value Metric computation method to use for validation metrics.
     */
    @JvmName("tvxefpffxmdlwmdy")
    public fun validationMetricType(`value`: ValidationMetricType) {
        val toBeMapped = Either.ofRight<String, ValidationMetricType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validationMetricType = mapped
    }

    /**
     * @param value Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
     */
    @JvmName("kidhjlvjcnncigwd")
    public suspend fun warmupCosineLRCycles(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warmupCosineLRCycles = mapped
    }

    /**
     * @param value Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
     */
    @JvmName("cukcmauaofjamitd")
    public suspend fun warmupCosineLRWarmupEpochs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warmupCosineLRWarmupEpochs = mapped
    }

    /**
     * @param value Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
     */
    @JvmName("bicqhmrdcagufccq")
    public suspend fun weightDecay(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightDecay = mapped
    }

    internal fun build(): ImageModelSettingsObjectDetectionArgs =
        ImageModelSettingsObjectDetectionArgs(
            advancedSettings = advancedSettings,
            amsGradient = amsGradient,
            augmentations = augmentations,
            beta1 = beta1,
            beta2 = beta2,
            boxDetectionsPerImage = boxDetectionsPerImage,
            boxScoreThreshold = boxScoreThreshold,
            checkpointFrequency = checkpointFrequency,
            checkpointModel = checkpointModel,
            checkpointRunId = checkpointRunId,
            distributed = distributed,
            earlyStopping = earlyStopping,
            earlyStoppingDelay = earlyStoppingDelay,
            earlyStoppingPatience = earlyStoppingPatience,
            enableOnnxNormalization = enableOnnxNormalization,
            evaluationFrequency = evaluationFrequency,
            gradientAccumulationStep = gradientAccumulationStep,
            imageSize = imageSize,
            layersToFreeze = layersToFreeze,
            learningRate = learningRate,
            learningRateScheduler = learningRateScheduler,
            maxSize = maxSize,
            minSize = minSize,
            modelName = modelName,
            modelSize = modelSize,
            momentum = momentum,
            multiScale = multiScale,
            nesterov = nesterov,
            nmsIouThreshold = nmsIouThreshold,
            numberOfEpochs = numberOfEpochs,
            numberOfWorkers = numberOfWorkers,
            optimizer = optimizer,
            randomSeed = randomSeed,
            stepLRGamma = stepLRGamma,
            stepLRStepSize = stepLRStepSize,
            tileGridSize = tileGridSize,
            tileOverlapRatio = tileOverlapRatio,
            tilePredictionsNmsThreshold = tilePredictionsNmsThreshold,
            trainingBatchSize = trainingBatchSize,
            validationBatchSize = validationBatchSize,
            validationIouThreshold = validationIouThreshold,
            validationMetricType = validationMetricType,
            warmupCosineLRCycles = warmupCosineLRCycles,
            warmupCosineLRWarmupEpochs = warmupCosineLRWarmupEpochs,
            weightDecay = weightDecay,
        )
}
