@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.KubernetesPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Kubernetes properties
 * @property defaultInstanceType Default instance type
 * @property extensionInstanceReleaseTrain Extension instance release train.
 * @property extensionPrincipalId Extension principal-id.
 * @property instanceTypes Instance Type Schema
 * @property namespace Compute namespace
 * @property relayConnectionString Relay connection string.
 * @property serviceBusConnectionString ServiceBus connection string.
 * @property vcName VC name.
 */
public data class KubernetesPropertiesArgs(
    public val defaultInstanceType: Output<String>? = null,
    public val extensionInstanceReleaseTrain: Output<String>? = null,
    public val extensionPrincipalId: Output<String>? = null,
    public val instanceTypes: Output<Map<String, InstanceTypeSchemaArgs>>? = null,
    public val namespace: Output<String>? = null,
    public val relayConnectionString: Output<String>? = null,
    public val serviceBusConnectionString: Output<String>? = null,
    public val vcName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.KubernetesPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.KubernetesPropertiesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.KubernetesPropertiesArgs.builder()
            .defaultInstanceType(defaultInstanceType?.applyValue({ args0 -> args0 }))
            .extensionInstanceReleaseTrain(extensionInstanceReleaseTrain?.applyValue({ args0 -> args0 }))
            .extensionPrincipalId(extensionPrincipalId?.applyValue({ args0 -> args0 }))
            .instanceTypes(
                instanceTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .relayConnectionString(relayConnectionString?.applyValue({ args0 -> args0 }))
            .serviceBusConnectionString(serviceBusConnectionString?.applyValue({ args0 -> args0 }))
            .vcName(vcName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KubernetesPropertiesArgs].
 */
@PulumiTagMarker
public class KubernetesPropertiesArgsBuilder internal constructor() {
    private var defaultInstanceType: Output<String>? = null

    private var extensionInstanceReleaseTrain: Output<String>? = null

    private var extensionPrincipalId: Output<String>? = null

    private var instanceTypes: Output<Map<String, InstanceTypeSchemaArgs>>? = null

    private var namespace: Output<String>? = null

    private var relayConnectionString: Output<String>? = null

    private var serviceBusConnectionString: Output<String>? = null

    private var vcName: Output<String>? = null

    /**
     * @param value Default instance type
     */
    @JvmName("xjcknqglmemprpnr")
    public suspend fun defaultInstanceType(`value`: Output<String>) {
        this.defaultInstanceType = value
    }

    /**
     * @param value Extension instance release train.
     */
    @JvmName("qlqsyohsbsqugdwn")
    public suspend fun extensionInstanceReleaseTrain(`value`: Output<String>) {
        this.extensionInstanceReleaseTrain = value
    }

    /**
     * @param value Extension principal-id.
     */
    @JvmName("xietbnsqkaeghgop")
    public suspend fun extensionPrincipalId(`value`: Output<String>) {
        this.extensionPrincipalId = value
    }

    /**
     * @param value Instance Type Schema
     */
    @JvmName("avtywlhrbgcebgxs")
    public suspend fun instanceTypes(`value`: Output<Map<String, InstanceTypeSchemaArgs>>) {
        this.instanceTypes = value
    }

    /**
     * @param value Compute namespace
     */
    @JvmName("snpjjnmqsebnvdmy")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value Relay connection string.
     */
    @JvmName("ymoowmxajbcjjqia")
    public suspend fun relayConnectionString(`value`: Output<String>) {
        this.relayConnectionString = value
    }

    /**
     * @param value ServiceBus connection string.
     */
    @JvmName("dxqtfxypwktkugha")
    public suspend fun serviceBusConnectionString(`value`: Output<String>) {
        this.serviceBusConnectionString = value
    }

    /**
     * @param value VC name.
     */
    @JvmName("vrniwtkuxpdsqqmd")
    public suspend fun vcName(`value`: Output<String>) {
        this.vcName = value
    }

    /**
     * @param value Default instance type
     */
    @JvmName("jfahschvlrqfwpak")
    public suspend fun defaultInstanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultInstanceType = mapped
    }

    /**
     * @param value Extension instance release train.
     */
    @JvmName("ksvfjxkethikgmdr")
    public suspend fun extensionInstanceReleaseTrain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionInstanceReleaseTrain = mapped
    }

    /**
     * @param value Extension principal-id.
     */
    @JvmName("ufdndyktfxkyyefa")
    public suspend fun extensionPrincipalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionPrincipalId = mapped
    }

    /**
     * @param value Instance Type Schema
     */
    @JvmName("kxnfotsotxvkvjir")
    public suspend fun instanceTypes(`value`: Map<String, InstanceTypeSchemaArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceTypes = mapped
    }

    /**
     * @param argument Instance Type Schema
     */
    @JvmName("flbdqjphsvycpftr")
    public suspend fun instanceTypes(
        vararg
        argument: Pair<String, suspend InstanceTypeSchemaArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                InstanceTypeSchemaArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.instanceTypes = mapped
    }

    /**
     * @param values Instance Type Schema
     */
    @JvmName("cwuuvjjyqmmumvsa")
    public fun instanceTypes(vararg values: Pair<String, InstanceTypeSchemaArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceTypes = mapped
    }

    /**
     * @param value Compute namespace
     */
    @JvmName("apcjdiubmaokmwra")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value Relay connection string.
     */
    @JvmName("gtltojjgiqtcxdly")
    public suspend fun relayConnectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relayConnectionString = mapped
    }

    /**
     * @param value ServiceBus connection string.
     */
    @JvmName("onnadpufibqiajum")
    public suspend fun serviceBusConnectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBusConnectionString = mapped
    }

    /**
     * @param value VC name.
     */
    @JvmName("ljnpeukysounckih")
    public suspend fun vcName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vcName = mapped
    }

    internal fun build(): KubernetesPropertiesArgs = KubernetesPropertiesArgs(
        defaultInstanceType = defaultInstanceType,
        extensionInstanceReleaseTrain = extensionInstanceReleaseTrain,
        extensionPrincipalId = extensionPrincipalId,
        instanceTypes = instanceTypes,
        namespace = namespace,
        relayConnectionString = relayConnectionString,
        serviceBusConnectionString = serviceBusConnectionString,
        vcName = vcName,
    )
}
