@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.LabelingJobArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Labeling job definition
 * @property componentId ARM resource ID of the component resource.
 * @property computeId ARM resource ID of the compute resource.
 * @property dataConfiguration Configuration of data used in the job.
 * @property description The asset description text.
 * @property displayName Display name of job.
 * @property experimentName The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
 * @property identity Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
 * Defaults to AmlToken if null.
 * @property isArchived Is the asset archived?
 * @property jobInstructions Labeling instructions of the job.
 * @property jobType Enum to determine the type of job.
 * Expected value is 'Labeling'.
 * @property labelCategories Label categories of the job.
 * @property labelingJobMediaProperties Media type specific properties in the job.
 * @property mlAssistConfiguration Configuration of MLAssist feature in the job.
 * @property notificationSetting Notification setting for the job
 * @property properties The asset property dictionary.
 * @property secretsConfiguration Configuration for secrets to be made available during runtime.
 * @property services List of JobEndpoints.
 * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class LabelingJobArgs(
    public val componentId: Output<String>? = null,
    public val computeId: Output<String>? = null,
    public val dataConfiguration: Output<LabelingDataConfigurationArgs>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val experimentName: Output<String>? = null,
    public val identity: Output<Any>? = null,
    public val isArchived: Output<Boolean>? = null,
    public val jobInstructions: Output<LabelingJobInstructionsArgs>? = null,
    public val jobType: Output<String>,
    public val labelCategories: Output<Map<String, LabelCategoryArgs>>? = null,
    public val labelingJobMediaProperties:
    Output<Either<LabelingJobImagePropertiesArgs, LabelingJobTextPropertiesArgs>>? = null,
    public val mlAssistConfiguration:
    Output<Either<MLAssistConfigurationDisabledArgs, MLAssistConfigurationEnabledArgs>>? = null,
    public val notificationSetting: Output<NotificationSettingArgs>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val secretsConfiguration: Output<Map<String, SecretConfigurationArgs>>? = null,
    public val services: Output<Map<String, JobServiceArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.LabelingJobArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.LabelingJobArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.LabelingJobArgs.builder()
            .componentId(componentId?.applyValue({ args0 -> args0 }))
            .computeId(computeId?.applyValue({ args0 -> args0 }))
            .dataConfiguration(dataConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .experimentName(experimentName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0 }))
            .isArchived(isArchived?.applyValue({ args0 -> args0 }))
            .jobInstructions(jobInstructions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jobType(jobType.applyValue({ args0 -> args0 }))
            .labelCategories(
                labelCategories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .labelingJobMediaProperties(
                labelingJobMediaProperties?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0.let({ args0 -> args0.toJava() }) }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .mlAssistConfiguration(
                mlAssistConfiguration?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .notificationSetting(
                notificationSetting?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .secretsConfiguration(
                secretsConfiguration?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .services(
                services?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LabelingJobArgs].
 */
@PulumiTagMarker
public class LabelingJobArgsBuilder internal constructor() {
    private var componentId: Output<String>? = null

    private var computeId: Output<String>? = null

    private var dataConfiguration: Output<LabelingDataConfigurationArgs>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var experimentName: Output<String>? = null

    private var identity: Output<Any>? = null

    private var isArchived: Output<Boolean>? = null

    private var jobInstructions: Output<LabelingJobInstructionsArgs>? = null

    private var jobType: Output<String>? = null

    private var labelCategories: Output<Map<String, LabelCategoryArgs>>? = null

    private var labelingJobMediaProperties:
        Output<Either<LabelingJobImagePropertiesArgs, LabelingJobTextPropertiesArgs>>? = null

    private var mlAssistConfiguration:
        Output<Either<MLAssistConfigurationDisabledArgs, MLAssistConfigurationEnabledArgs>>? = null

    private var notificationSetting: Output<NotificationSettingArgs>? = null

    private var properties: Output<Map<String, String>>? = null

    private var secretsConfiguration: Output<Map<String, SecretConfigurationArgs>>? = null

    private var services: Output<Map<String, JobServiceArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value ARM resource ID of the component resource.
     */
    @JvmName("nubswlgstqkbpvnj")
    public suspend fun componentId(`value`: Output<String>) {
        this.componentId = value
    }

    /**
     * @param value ARM resource ID of the compute resource.
     */
    @JvmName("aklgskejkopiblfi")
    public suspend fun computeId(`value`: Output<String>) {
        this.computeId = value
    }

    /**
     * @param value Configuration of data used in the job.
     */
    @JvmName("efxejeviprjjfkyy")
    public suspend fun dataConfiguration(`value`: Output<LabelingDataConfigurationArgs>) {
        this.dataConfiguration = value
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("ifgpomwmwvxmfdkc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Display name of job.
     */
    @JvmName("hrgcqwbpjegjoqlf")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
     */
    @JvmName("kvuwgldmysgtpuub")
    public suspend fun experimentName(`value`: Output<String>) {
        this.experimentName = value
    }

    /**
     * @param value Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
     * Defaults to AmlToken if null.
     */
    @JvmName("wyktgjocfbrdfgrj")
    public suspend fun identity(`value`: Output<Any>) {
        this.identity = value
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("fdsfxtelkavonrmd")
    public suspend fun isArchived(`value`: Output<Boolean>) {
        this.isArchived = value
    }

    /**
     * @param value Labeling instructions of the job.
     */
    @JvmName("gpbsqgcxjfpytmho")
    public suspend fun jobInstructions(`value`: Output<LabelingJobInstructionsArgs>) {
        this.jobInstructions = value
    }

    /**
     * @param value Enum to determine the type of job.
     * Expected value is 'Labeling'.
     */
    @JvmName("eufaqnpqmiohplqi")
    public suspend fun jobType(`value`: Output<String>) {
        this.jobType = value
    }

    /**
     * @param value Label categories of the job.
     */
    @JvmName("ittqbhmaqkitgddj")
    public suspend fun labelCategories(`value`: Output<Map<String, LabelCategoryArgs>>) {
        this.labelCategories = value
    }

    /**
     * @param value Media type specific properties in the job.
     */
    @JvmName("asyeikuyvomeaecn")
    public suspend
    fun labelingJobMediaProperties(`value`: Output<Either<LabelingJobImagePropertiesArgs, LabelingJobTextPropertiesArgs>>) {
        this.labelingJobMediaProperties = value
    }

    /**
     * @param value Configuration of MLAssist feature in the job.
     */
    @JvmName("yrxidapjjkqwmudl")
    public suspend
    fun mlAssistConfiguration(`value`: Output<Either<MLAssistConfigurationDisabledArgs, MLAssistConfigurationEnabledArgs>>) {
        this.mlAssistConfiguration = value
    }

    /**
     * @param value Notification setting for the job
     */
    @JvmName("ekqynsiskecwaqqk")
    public suspend fun notificationSetting(`value`: Output<NotificationSettingArgs>) {
        this.notificationSetting = value
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("nfckekoepfvapebi")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Configuration for secrets to be made available during runtime.
     */
    @JvmName("jyvxusokpjwaoopx")
    public suspend fun secretsConfiguration(`value`: Output<Map<String, SecretConfigurationArgs>>) {
        this.secretsConfiguration = value
    }

    /**
     * @param value List of JobEndpoints.
     * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
     */
    @JvmName("elmlloqaarpgoqpx")
    public suspend fun services(`value`: Output<Map<String, JobServiceArgs>>) {
        this.services = value
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("xdlbalaetjomcbhj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ARM resource ID of the component resource.
     */
    @JvmName("bvctrveltiiugfit")
    public suspend fun componentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentId = mapped
    }

    /**
     * @param value ARM resource ID of the compute resource.
     */
    @JvmName("rltyugocusdnokio")
    public suspend fun computeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeId = mapped
    }

    /**
     * @param value Configuration of data used in the job.
     */
    @JvmName("etgpqurddnymvbjj")
    public suspend fun dataConfiguration(`value`: LabelingDataConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataConfiguration = mapped
    }

    /**
     * @param argument Configuration of data used in the job.
     */
    @JvmName("vugwwbgftgqudosm")
    public suspend
    fun dataConfiguration(argument: suspend LabelingDataConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = LabelingDataConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataConfiguration = mapped
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("meethtvwlwofruhr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Display name of job.
     */
    @JvmName("npbhrvpobgbcmwgt")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
     */
    @JvmName("vjsmhtsngnfcxolf")
    public suspend fun experimentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.experimentName = mapped
    }

    /**
     * @param value Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
     * Defaults to AmlToken if null.
     */
    @JvmName("yimctogmtmqjenui")
    public suspend fun identity(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("swuuvsyxfkgvhpjs")
    public suspend fun isArchived(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchived = mapped
    }

    /**
     * @param value Labeling instructions of the job.
     */
    @JvmName("lbeltauhmjbedttd")
    public suspend fun jobInstructions(`value`: LabelingJobInstructionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobInstructions = mapped
    }

    /**
     * @param argument Labeling instructions of the job.
     */
    @JvmName("sefkqgjcuwmnpddd")
    public suspend
    fun jobInstructions(argument: suspend LabelingJobInstructionsArgsBuilder.() -> Unit) {
        val toBeMapped = LabelingJobInstructionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.jobInstructions = mapped
    }

    /**
     * @param value Enum to determine the type of job.
     * Expected value is 'Labeling'.
     */
    @JvmName("mhwjphpjhtbvyoqe")
    public suspend fun jobType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobType = mapped
    }

    /**
     * @param value Label categories of the job.
     */
    @JvmName("efybnoscjidqupft")
    public suspend fun labelCategories(`value`: Map<String, LabelCategoryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelCategories = mapped
    }

    /**
     * @param argument Label categories of the job.
     */
    @JvmName("maulfowjqgrllryg")
    public suspend fun labelCategories(
        vararg
        argument: Pair<String, suspend LabelCategoryArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                LabelCategoryArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.labelCategories = mapped
    }

    /**
     * @param values Label categories of the job.
     */
    @JvmName("xbfpnvxpkdnbbmrm")
    public fun labelCategories(vararg values: Pair<String, LabelCategoryArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labelCategories = mapped
    }

    /**
     * @param value Media type specific properties in the job.
     */
    @JvmName("ecexwwlthemodkdx")
    public suspend
    fun labelingJobMediaProperties(`value`: Either<LabelingJobImagePropertiesArgs, LabelingJobTextPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelingJobMediaProperties = mapped
    }

    /**
     * @param value Media type specific properties in the job.
     */
    @JvmName("fjtbubtkddturmgb")
    public fun labelingJobMediaProperties(`value`: LabelingJobImagePropertiesArgs) {
        val toBeMapped = Either.ofLeft<LabelingJobImagePropertiesArgs,
            LabelingJobTextPropertiesArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labelingJobMediaProperties = mapped
    }

    /**
     * @param value Media type specific properties in the job.
     */
    @JvmName("yijmbkorijkrtgay")
    public fun labelingJobMediaProperties(`value`: LabelingJobTextPropertiesArgs) {
        val toBeMapped = Either.ofRight<LabelingJobImagePropertiesArgs,
            LabelingJobTextPropertiesArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labelingJobMediaProperties = mapped
    }

    /**
     * @param value Configuration of MLAssist feature in the job.
     */
    @JvmName("nobkxxcgxipatfug")
    public suspend
    fun mlAssistConfiguration(`value`: Either<MLAssistConfigurationDisabledArgs, MLAssistConfigurationEnabledArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mlAssistConfiguration = mapped
    }

    /**
     * @param value Configuration of MLAssist feature in the job.
     */
    @JvmName("llcfcxdscpmqdweo")
    public fun mlAssistConfiguration(`value`: MLAssistConfigurationDisabledArgs) {
        val toBeMapped = Either.ofLeft<MLAssistConfigurationDisabledArgs,
            MLAssistConfigurationEnabledArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mlAssistConfiguration = mapped
    }

    /**
     * @param value Configuration of MLAssist feature in the job.
     */
    @JvmName("bxohpgjjxehpbaus")
    public fun mlAssistConfiguration(`value`: MLAssistConfigurationEnabledArgs) {
        val toBeMapped = Either.ofRight<MLAssistConfigurationDisabledArgs,
            MLAssistConfigurationEnabledArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mlAssistConfiguration = mapped
    }

    /**
     * @param value Notification setting for the job
     */
    @JvmName("dwueudcngobdqfde")
    public suspend fun notificationSetting(`value`: NotificationSettingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationSetting = mapped
    }

    /**
     * @param argument Notification setting for the job
     */
    @JvmName("agobjeyhspmtfamn")
    public suspend
    fun notificationSetting(argument: suspend NotificationSettingArgsBuilder.() -> Unit) {
        val toBeMapped = NotificationSettingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.notificationSetting = mapped
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("xonauxdilqaameow")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values The asset property dictionary.
     */
    @JvmName("altjkypkcnrtrcqv")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Configuration for secrets to be made available during runtime.
     */
    @JvmName("opmsoeyvflxdycax")
    public suspend fun secretsConfiguration(`value`: Map<String, SecretConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretsConfiguration = mapped
    }

    /**
     * @param argument Configuration for secrets to be made available during runtime.
     */
    @JvmName("bmdbloweaktoiapr")
    public suspend fun secretsConfiguration(
        vararg
        argument: Pair<String, suspend SecretConfigurationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                SecretConfigurationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.secretsConfiguration = mapped
    }

    /**
     * @param values Configuration for secrets to be made available during runtime.
     */
    @JvmName("rvtbuvwuyggmvenr")
    public fun secretsConfiguration(vararg values: Pair<String, SecretConfigurationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretsConfiguration = mapped
    }

    /**
     * @param value List of JobEndpoints.
     * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
     */
    @JvmName("hmctulharquatwhh")
    public suspend fun services(`value`: Map<String, JobServiceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.services = mapped
    }

    /**
     * @param argument List of JobEndpoints.
     * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
     */
    @JvmName("xqypwmvnthlbjewg")
    public suspend fun services(
        vararg
        argument: Pair<String, suspend JobServiceArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                JobServiceArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.services = mapped
    }

    /**
     * @param values List of JobEndpoints.
     * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
     */
    @JvmName("vjjovpohcgxweyvw")
    public fun services(vararg values: Pair<String, JobServiceArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.services = mapped
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("jriqbsmmcfillnhm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("qbmbglyfnlwunnxx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LabelingJobArgs = LabelingJobArgs(
        componentId = componentId,
        computeId = computeId,
        dataConfiguration = dataConfiguration,
        description = description,
        displayName = displayName,
        experimentName = experimentName,
        identity = identity,
        isArchived = isArchived,
        jobInstructions = jobInstructions,
        jobType = jobType ?: throw PulumiNullFieldException("jobType"),
        labelCategories = labelCategories,
        labelingJobMediaProperties = labelingJobMediaProperties,
        mlAssistConfiguration = mlAssistConfiguration,
        notificationSetting = notificationSetting,
        properties = properties,
        secretsConfiguration = secretsConfiguration,
        services = services,
        tags = tags,
    )
}
