@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.MLTableDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * MLTable data definition
 * @property dataType Enum to determine the type of data.
 * Expected value is 'mltable'.
 * @property dataUri [Required] Uri of the data. Example: https://go.microsoft.com/fwlink/?linkid=2202330
 * @property description The asset description text.
 * @property isAnonymous If the name version are system generated (anonymous registration).
 * @property isArchived Is the asset archived?
 * @property properties The asset property dictionary.
 * @property referencedUris Uris referenced in the MLTable definition (required for lineage)
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class MLTableDataArgs(
    public val dataType: Output<String>,
    public val dataUri: Output<String>,
    public val description: Output<String>? = null,
    public val isAnonymous: Output<Boolean>? = null,
    public val isArchived: Output<Boolean>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val referencedUris: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.MLTableDataArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.MLTableDataArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.MLTableDataArgs.builder()
            .dataType(dataType.applyValue({ args0 -> args0 }))
            .dataUri(dataUri.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .isAnonymous(isAnonymous?.applyValue({ args0 -> args0 }))
            .isArchived(isArchived?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .referencedUris(referencedUris?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MLTableDataArgs].
 */
@PulumiTagMarker
public class MLTableDataArgsBuilder internal constructor() {
    private var dataType: Output<String>? = null

    private var dataUri: Output<String>? = null

    private var description: Output<String>? = null

    private var isAnonymous: Output<Boolean>? = null

    private var isArchived: Output<Boolean>? = null

    private var properties: Output<Map<String, String>>? = null

    private var referencedUris: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Enum to determine the type of data.
     * Expected value is 'mltable'.
     */
    @JvmName("cwwbuycklcmsolka")
    public suspend fun dataType(`value`: Output<String>) {
        this.dataType = value
    }

    /**
     * @param value [Required] Uri of the data. Example: https://go.microsoft.com/fwlink/?linkid=2202330
     */
    @JvmName("jkljnembbyrirabq")
    public suspend fun dataUri(`value`: Output<String>) {
        this.dataUri = value
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("stjrloftxvldphdc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value If the name version are system generated (anonymous registration).
     */
    @JvmName("yxjmdwcyxnxcodld")
    public suspend fun isAnonymous(`value`: Output<Boolean>) {
        this.isAnonymous = value
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("kmkybpnjflagahrm")
    public suspend fun isArchived(`value`: Output<Boolean>) {
        this.isArchived = value
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("fctsfdrwraxnaavj")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Uris referenced in the MLTable definition (required for lineage)
     */
    @JvmName("ndmcwfholgsjwtfl")
    public suspend fun referencedUris(`value`: Output<List<String>>) {
        this.referencedUris = value
    }

    @JvmName("wdqkqpgifmbgyhgw")
    public suspend fun referencedUris(vararg values: Output<String>) {
        this.referencedUris = Output.all(values.asList())
    }

    /**
     * @param values Uris referenced in the MLTable definition (required for lineage)
     */
    @JvmName("lwndohfpldxxdlvq")
    public suspend fun referencedUris(values: List<Output<String>>) {
        this.referencedUris = Output.all(values)
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("nqbkyrgcqntnudsr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Enum to determine the type of data.
     * Expected value is 'mltable'.
     */
    @JvmName("rwctlelqjjyikama")
    public suspend fun dataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataType = mapped
    }

    /**
     * @param value [Required] Uri of the data. Example: https://go.microsoft.com/fwlink/?linkid=2202330
     */
    @JvmName("nbdjceyefnpwmcpg")
    public suspend fun dataUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataUri = mapped
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("nnmpytpmotuqgned")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value If the name version are system generated (anonymous registration).
     */
    @JvmName("csnpwrhrauygdybo")
    public suspend fun isAnonymous(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAnonymous = mapped
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("eicxvqvorqwyycyx")
    public suspend fun isArchived(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchived = mapped
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("ylnxbifyxursbkie")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values The asset property dictionary.
     */
    @JvmName("gduvljjotrhsholn")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Uris referenced in the MLTable definition (required for lineage)
     */
    @JvmName("ryvxcgbmwrmfladm")
    public suspend fun referencedUris(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referencedUris = mapped
    }

    /**
     * @param values Uris referenced in the MLTable definition (required for lineage)
     */
    @JvmName("ewicuvexayqubrsr")
    public suspend fun referencedUris(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referencedUris = mapped
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("nibxfnusdjgswftc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("ubdjuecoxdpkqlgd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MLTableDataArgs = MLTableDataArgs(
        dataType = dataType ?: throw PulumiNullFieldException("dataType"),
        dataUri = dataUri ?: throw PulumiNullFieldException("dataUri"),
        description = description,
        isAnonymous = isAnonymous,
        isArchived = isArchived,
        properties = properties,
        referencedUris = referencedUris,
        tags = tags,
    )
}
