@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.MaterializationComputeResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Dto object representing compute resource
 * @property instanceType Specifies the instance type
 */
public data class MaterializationComputeResourceArgs(
    public val instanceType: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.MaterializationComputeResourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.MaterializationComputeResourceArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.MaterializationComputeResourceArgs.builder()
            .instanceType(instanceType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MaterializationComputeResourceArgs].
 */
@PulumiTagMarker
public class MaterializationComputeResourceArgsBuilder internal constructor() {
    private var instanceType: Output<String>? = null

    /**
     * @param value Specifies the instance type
     */
    @JvmName("qseeaxifqhlajvtg")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Specifies the instance type
     */
    @JvmName("yikdcgkepkavxfsy")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    internal fun build(): MaterializationComputeResourceArgs = MaterializationComputeResourceArgs(
        instanceType = instanceType,
    )
}
