@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.MpiArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * MPI distribution configuration.
 * @property distributionType Enum to determine the job distribution type.
 * Expected value is 'Mpi'.
 * @property processCountPerInstance Number of processes per MPI node.
 */
public data class MpiArgs(
    public val distributionType: Output<String>,
    public val processCountPerInstance: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.MpiArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.MpiArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.MpiArgs.builder()
            .distributionType(distributionType.applyValue({ args0 -> args0 }))
            .processCountPerInstance(processCountPerInstance?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MpiArgs].
 */
@PulumiTagMarker
public class MpiArgsBuilder internal constructor() {
    private var distributionType: Output<String>? = null

    private var processCountPerInstance: Output<Int>? = null

    /**
     * @param value Enum to determine the job distribution type.
     * Expected value is 'Mpi'.
     */
    @JvmName("jwectjeuxkekwhpb")
    public suspend fun distributionType(`value`: Output<String>) {
        this.distributionType = value
    }

    /**
     * @param value Number of processes per MPI node.
     */
    @JvmName("qwnmpkymqwwidlix")
    public suspend fun processCountPerInstance(`value`: Output<Int>) {
        this.processCountPerInstance = value
    }

    /**
     * @param value Enum to determine the job distribution type.
     * Expected value is 'Mpi'.
     */
    @JvmName("qhifjrjqkgrhruxs")
    public suspend fun distributionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.distributionType = mapped
    }

    /**
     * @param value Number of processes per MPI node.
     */
    @JvmName("ghltajoodxbypiiv")
    public suspend fun processCountPerInstance(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processCountPerInstance = mapped
    }

    internal fun build(): MpiArgs = MpiArgs(
        distributionType = distributionType ?: throw PulumiNullFieldException("distributionType"),
        processCountPerInstance = processCountPerInstance,
    )
}
