@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ObjectiveArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.Goal
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Optimization objective.
 * @property goal [Required] Defines supported metric goals for hyperparameter tuning
 * @property primaryMetric [Required] Name of the metric to optimize.
 */
public data class ObjectiveArgs(
    public val goal: Output<Either<String, Goal>>,
    public val primaryMetric: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ObjectiveArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ObjectiveArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ObjectiveArgs.builder()
            .goal(
                goal.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .primaryMetric(primaryMetric.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ObjectiveArgs].
 */
@PulumiTagMarker
public class ObjectiveArgsBuilder internal constructor() {
    private var goal: Output<Either<String, Goal>>? = null

    private var primaryMetric: Output<String>? = null

    /**
     * @param value [Required] Defines supported metric goals for hyperparameter tuning
     */
    @JvmName("myhbxmysrlvplajs")
    public suspend fun goal(`value`: Output<Either<String, Goal>>) {
        this.goal = value
    }

    /**
     * @param value [Required] Name of the metric to optimize.
     */
    @JvmName("wxrhqaveohphknaa")
    public suspend fun primaryMetric(`value`: Output<String>) {
        this.primaryMetric = value
    }

    /**
     * @param value [Required] Defines supported metric goals for hyperparameter tuning
     */
    @JvmName("qqsmvbwmikuymccr")
    public suspend fun goal(`value`: Either<String, Goal>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.goal = mapped
    }

    /**
     * @param value [Required] Defines supported metric goals for hyperparameter tuning
     */
    @JvmName("mcppraparmuklapj")
    public fun goal(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Goal>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.goal = mapped
    }

    /**
     * @param value [Required] Defines supported metric goals for hyperparameter tuning
     */
    @JvmName("rfwsfeoxscabmjsr")
    public fun goal(`value`: Goal) {
        val toBeMapped = Either.ofRight<String, Goal>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.goal = mapped
    }

    /**
     * @param value [Required] Name of the metric to optimize.
     */
    @JvmName("shipwcnmdvrpkirq")
    public suspend fun primaryMetric(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryMetric = mapped
    }

    internal fun build(): ObjectiveArgs = ObjectiveArgs(
        goal = goal ?: throw PulumiNullFieldException("goal"),
        primaryMetric = primaryMetric ?: throw PulumiNullFieldException("primaryMetric"),
    )
}
