@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.OnlineRequestSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Online deployment scoring requests configuration.
 * @property maxConcurrentRequestsPerInstance The number of maximum concurrent requests per node allowed per deployment. Defaults to 1.
 * @property maxQueueWait The maximum amount of time a request will stay in the queue in ISO 8601 format.
 * Defaults to 500ms.
 * @property requestTimeout The scoring timeout in ISO 8601 format.
 * Defaults to 5000ms.
 */
public data class OnlineRequestSettingsArgs(
    public val maxConcurrentRequestsPerInstance: Output<Int>? = null,
    public val maxQueueWait: Output<String>? = null,
    public val requestTimeout: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.OnlineRequestSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.OnlineRequestSettingsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.OnlineRequestSettingsArgs.builder()
            .maxConcurrentRequestsPerInstance(maxConcurrentRequestsPerInstance?.applyValue({ args0 -> args0 }))
            .maxQueueWait(maxQueueWait?.applyValue({ args0 -> args0 }))
            .requestTimeout(requestTimeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OnlineRequestSettingsArgs].
 */
@PulumiTagMarker
public class OnlineRequestSettingsArgsBuilder internal constructor() {
    private var maxConcurrentRequestsPerInstance: Output<Int>? = null

    private var maxQueueWait: Output<String>? = null

    private var requestTimeout: Output<String>? = null

    /**
     * @param value The number of maximum concurrent requests per node allowed per deployment. Defaults to 1.
     */
    @JvmName("yrpwunmlnjyfdwhw")
    public suspend fun maxConcurrentRequestsPerInstance(`value`: Output<Int>) {
        this.maxConcurrentRequestsPerInstance = value
    }

    /**
     * @param value The maximum amount of time a request will stay in the queue in ISO 8601 format.
     * Defaults to 500ms.
     */
    @JvmName("lkijcjoxbeifvpeu")
    public suspend fun maxQueueWait(`value`: Output<String>) {
        this.maxQueueWait = value
    }

    /**
     * @param value The scoring timeout in ISO 8601 format.
     * Defaults to 5000ms.
     */
    @JvmName("spjqkhhwopxibtwa")
    public suspend fun requestTimeout(`value`: Output<String>) {
        this.requestTimeout = value
    }

    /**
     * @param value The number of maximum concurrent requests per node allowed per deployment. Defaults to 1.
     */
    @JvmName("xcaboqjirvbwphie")
    public suspend fun maxConcurrentRequestsPerInstance(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentRequestsPerInstance = mapped
    }

    /**
     * @param value The maximum amount of time a request will stay in the queue in ISO 8601 format.
     * Defaults to 500ms.
     */
    @JvmName("gkfnbqlatkuluvow")
    public suspend fun maxQueueWait(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxQueueWait = mapped
    }

    /**
     * @param value The scoring timeout in ISO 8601 format.
     * Defaults to 5000ms.
     */
    @JvmName("wwspsbnolsabovtq")
    public suspend fun requestTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestTimeout = mapped
    }

    internal fun build(): OnlineRequestSettingsArgs = OnlineRequestSettingsArgs(
        maxConcurrentRequestsPerInstance = maxConcurrentRequestsPerInstance,
        maxQueueWait = maxQueueWait,
        requestTimeout = requestTimeout,
    )
}
