@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.OutputPathAssetReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Reference to an asset via its path in a job output.
 * @property jobId ARM resource ID of the job.
 * @property path The path of the file/directory in the job output.
 * @property referenceType Enum to determine which reference method to use for an asset.
 * Expected value is 'OutputPath'.
 */
public data class OutputPathAssetReferenceArgs(
    public val jobId: Output<String>? = null,
    public val path: Output<String>? = null,
    public val referenceType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.OutputPathAssetReferenceArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.OutputPathAssetReferenceArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.OutputPathAssetReferenceArgs.builder()
            .jobId(jobId?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .referenceType(referenceType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OutputPathAssetReferenceArgs].
 */
@PulumiTagMarker
public class OutputPathAssetReferenceArgsBuilder internal constructor() {
    private var jobId: Output<String>? = null

    private var path: Output<String>? = null

    private var referenceType: Output<String>? = null

    /**
     * @param value ARM resource ID of the job.
     */
    @JvmName("pksuuxniwuoxuyfp")
    public suspend fun jobId(`value`: Output<String>) {
        this.jobId = value
    }

    /**
     * @param value The path of the file/directory in the job output.
     */
    @JvmName("cpynplfsenxvdtty")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Enum to determine which reference method to use for an asset.
     * Expected value is 'OutputPath'.
     */
    @JvmName("efbhgubakynfqtoe")
    public suspend fun referenceType(`value`: Output<String>) {
        this.referenceType = value
    }

    /**
     * @param value ARM resource ID of the job.
     */
    @JvmName("dqbepbafixtajwjb")
    public suspend fun jobId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobId = mapped
    }

    /**
     * @param value The path of the file/directory in the job output.
     */
    @JvmName("jxunkbfyboibcbny")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Enum to determine which reference method to use for an asset.
     * Expected value is 'OutputPath'.
     */
    @JvmName("vrsrtiijbqxqgtwd")
    public suspend fun referenceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referenceType = mapped
    }

    internal fun build(): OutputPathAssetReferenceArgs = OutputPathAssetReferenceArgs(
        jobId = jobId,
        path = path,
        referenceType = referenceType ?: throw PulumiNullFieldException("referenceType"),
    )
}
