@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.PATAuthTypeWorkspaceConnectionPropertiesArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ConnectionCategory
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ValueFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property authType Authentication type of the connection target
 * Expected value is 'PAT'.
 * @property category Category of the connection
 * @property credentials
 * @property target
 * @property value Value details of the workspace connection.
 * @property valueFormat format for the workspace connection value
 */
public data class PATAuthTypeWorkspaceConnectionPropertiesArgs(
    public val authType: Output<String>,
    public val category: Output<Either<String, ConnectionCategory>>? = null,
    public val credentials: Output<WorkspaceConnectionPersonalAccessTokenArgs>? = null,
    public val target: Output<String>? = null,
    public val `value`: Output<String>? = null,
    public val valueFormat: Output<Either<String, ValueFormat>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.PATAuthTypeWorkspaceConnectionPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.PATAuthTypeWorkspaceConnectionPropertiesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.PATAuthTypeWorkspaceConnectionPropertiesArgs.builder()
            .authType(authType.applyValue({ args0 -> args0 }))
            .category(
                category?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .credentials(credentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .target(target?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 }))
            .valueFormat(
                valueFormat?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PATAuthTypeWorkspaceConnectionPropertiesArgs].
 */
@PulumiTagMarker
public class PATAuthTypeWorkspaceConnectionPropertiesArgsBuilder internal constructor() {
    private var authType: Output<String>? = null

    private var category: Output<Either<String, ConnectionCategory>>? = null

    private var credentials: Output<WorkspaceConnectionPersonalAccessTokenArgs>? = null

    private var target: Output<String>? = null

    private var `value`: Output<String>? = null

    private var valueFormat: Output<Either<String, ValueFormat>>? = null

    /**
     * @param value Authentication type of the connection target
     * Expected value is 'PAT'.
     */
    @JvmName("eifvnlnpnnwrsnbc")
    public suspend fun authType(`value`: Output<String>) {
        this.authType = value
    }

    /**
     * @param value Category of the connection
     */
    @JvmName("ccqwglrnlkbrwbit")
    public suspend fun category(`value`: Output<Either<String, ConnectionCategory>>) {
        this.category = value
    }

    /**
     * @param value
     */
    @JvmName("nqejidscsoswvqkb")
    public suspend fun credentials(`value`: Output<WorkspaceConnectionPersonalAccessTokenArgs>) {
        this.credentials = value
    }

    /**
     * @param value
     */
    @JvmName("exkgtuqtjgtjbxnd")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value Value details of the workspace connection.
     */
    @JvmName("airrmjcipmpnvdiu")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value format for the workspace connection value
     */
    @JvmName("bugapvsmhuwuiiqn")
    public suspend fun valueFormat(`value`: Output<Either<String, ValueFormat>>) {
        this.valueFormat = value
    }

    /**
     * @param value Authentication type of the connection target
     * Expected value is 'PAT'.
     */
    @JvmName("kqhhsqagthooneqg")
    public suspend fun authType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param value Category of the connection
     */
    @JvmName("lpeakkrbpplviose")
    public suspend fun category(`value`: Either<String, ConnectionCategory>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Category of the connection
     */
    @JvmName("hdeijhyrtbgfboed")
    public fun category(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConnectionCategory>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Category of the connection
     */
    @JvmName("hkksfrysalbyvdbi")
    public fun category(`value`: ConnectionCategory) {
        val toBeMapped = Either.ofRight<String, ConnectionCategory>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value
     */
    @JvmName("ggobojrtmwqbpfot")
    public suspend fun credentials(`value`: WorkspaceConnectionPersonalAccessTokenArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ulxdllgsmonypdqb")
    public suspend
    fun credentials(argument: suspend WorkspaceConnectionPersonalAccessTokenArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceConnectionPersonalAccessTokenArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value
     */
    @JvmName("ehbadopokgpuvfad")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param value Value details of the workspace connection.
     */
    @JvmName("jocsckwiiiuctutt")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param value format for the workspace connection value
     */
    @JvmName("dnvtaprfiqwuvfag")
    public suspend fun valueFormat(`value`: Either<String, ValueFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.valueFormat = mapped
    }

    /**
     * @param value format for the workspace connection value
     */
    @JvmName("pgvreggdrbjrhuup")
    public fun valueFormat(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ValueFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.valueFormat = mapped
    }

    /**
     * @param value format for the workspace connection value
     */
    @JvmName("miydoimroubndswu")
    public fun valueFormat(`value`: ValueFormat) {
        val toBeMapped = Either.ofRight<String, ValueFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.valueFormat = mapped
    }

    internal fun build(): PATAuthTypeWorkspaceConnectionPropertiesArgs =
        PATAuthTypeWorkspaceConnectionPropertiesArgs(
            authType = authType ?: throw PulumiNullFieldException("authType"),
            category = category,
            credentials = credentials,
            target = target,
            `value` = `value`,
            valueFormat = valueFormat,
        )
}
