@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.PersonalComputeInstanceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Settings for a personal compute instance.
 * @property assignedUser A user explicitly assigned to a personal compute instance.
 */
public data class PersonalComputeInstanceSettingsArgs(
    public val assignedUser: Output<AssignedUserArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.PersonalComputeInstanceSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.PersonalComputeInstanceSettingsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.PersonalComputeInstanceSettingsArgs.builder()
            .assignedUser(assignedUser?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PersonalComputeInstanceSettingsArgs].
 */
@PulumiTagMarker
public class PersonalComputeInstanceSettingsArgsBuilder internal constructor() {
    private var assignedUser: Output<AssignedUserArgs>? = null

    /**
     * @param value A user explicitly assigned to a personal compute instance.
     */
    @JvmName("jegxdhhioptwytgw")
    public suspend fun assignedUser(`value`: Output<AssignedUserArgs>) {
        this.assignedUser = value
    }

    /**
     * @param value A user explicitly assigned to a personal compute instance.
     */
    @JvmName("iiumvnpfevhdysrg")
    public suspend fun assignedUser(`value`: AssignedUserArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignedUser = mapped
    }

    /**
     * @param argument A user explicitly assigned to a personal compute instance.
     */
    @JvmName("behhlryqapflppat")
    public suspend fun assignedUser(argument: suspend AssignedUserArgsBuilder.() -> Unit) {
        val toBeMapped = AssignedUserArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.assignedUser = mapped
    }

    internal fun build(): PersonalComputeInstanceSettingsArgs = PersonalComputeInstanceSettingsArgs(
        assignedUser = assignedUser,
    )
}
