@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.PrivateEndpointResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The PE network resource that is linked to this PE connection.
 * @property subnetArmId The subnetId that the private endpoint is connected to.
 */
public data class PrivateEndpointResourceArgs(
    public val subnetArmId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.PrivateEndpointResourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.PrivateEndpointResourceArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.PrivateEndpointResourceArgs.builder()
            .subnetArmId(subnetArmId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointResourceArgs].
 */
@PulumiTagMarker
public class PrivateEndpointResourceArgsBuilder internal constructor() {
    private var subnetArmId: Output<String>? = null

    /**
     * @param value The subnetId that the private endpoint is connected to.
     */
    @JvmName("lcwpytankwxmhgvp")
    public suspend fun subnetArmId(`value`: Output<String>) {
        this.subnetArmId = value
    }

    /**
     * @param value The subnetId that the private endpoint is connected to.
     */
    @JvmName("lffqlkjhycyhvywt")
    public suspend fun subnetArmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetArmId = mapped
    }

    internal fun build(): PrivateEndpointResourceArgs = PrivateEndpointResourceArgs(
        subnetArmId = subnetArmId,
    )
}
