@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ProbeSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Deployment container liveness/readiness probe configuration.
 * @property failureThreshold The number of failures to allow before returning an unhealthy status.
 * @property initialDelay The delay before the first probe in ISO 8601 format.
 * @property period The length of time between probes in ISO 8601 format.
 * @property successThreshold The number of successful probes before returning a healthy status.
 * @property timeout The probe timeout in ISO 8601 format.
 */
public data class ProbeSettingsArgs(
    public val failureThreshold: Output<Int>? = null,
    public val initialDelay: Output<String>? = null,
    public val period: Output<String>? = null,
    public val successThreshold: Output<Int>? = null,
    public val timeout: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ProbeSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ProbeSettingsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ProbeSettingsArgs.builder()
            .failureThreshold(failureThreshold?.applyValue({ args0 -> args0 }))
            .initialDelay(initialDelay?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .successThreshold(successThreshold?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProbeSettingsArgs].
 */
@PulumiTagMarker
public class ProbeSettingsArgsBuilder internal constructor() {
    private var failureThreshold: Output<Int>? = null

    private var initialDelay: Output<String>? = null

    private var period: Output<String>? = null

    private var successThreshold: Output<Int>? = null

    private var timeout: Output<String>? = null

    /**
     * @param value The number of failures to allow before returning an unhealthy status.
     */
    @JvmName("suvxacgasneqhrnd")
    public suspend fun failureThreshold(`value`: Output<Int>) {
        this.failureThreshold = value
    }

    /**
     * @param value The delay before the first probe in ISO 8601 format.
     */
    @JvmName("euaobkgcijhrlwxu")
    public suspend fun initialDelay(`value`: Output<String>) {
        this.initialDelay = value
    }

    /**
     * @param value The length of time between probes in ISO 8601 format.
     */
    @JvmName("csusqwwodpgoeuje")
    public suspend fun period(`value`: Output<String>) {
        this.period = value
    }

    /**
     * @param value The number of successful probes before returning a healthy status.
     */
    @JvmName("wwghkbcjgurmbxvy")
    public suspend fun successThreshold(`value`: Output<Int>) {
        this.successThreshold = value
    }

    /**
     * @param value The probe timeout in ISO 8601 format.
     */
    @JvmName("buwpvdlhtqquwfub")
    public suspend fun timeout(`value`: Output<String>) {
        this.timeout = value
    }

    /**
     * @param value The number of failures to allow before returning an unhealthy status.
     */
    @JvmName("rclojvgsxobjrcxm")
    public suspend fun failureThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureThreshold = mapped
    }

    /**
     * @param value The delay before the first probe in ISO 8601 format.
     */
    @JvmName("hnemmluoibqvkefw")
    public suspend fun initialDelay(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialDelay = mapped
    }

    /**
     * @param value The length of time between probes in ISO 8601 format.
     */
    @JvmName("auqerpwkcdsmshxj")
    public suspend fun period(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The number of successful probes before returning a healthy status.
     */
    @JvmName("drtdcdryumpuwxfo")
    public suspend fun successThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successThreshold = mapped
    }

    /**
     * @param value The probe timeout in ISO 8601 format.
     */
    @JvmName("oouffkrgokxfxgff")
    public suspend fun timeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): ProbeSettingsArgs = ProbeSettingsArgs(
        failureThreshold = failureThreshold,
        initialDelay = initialDelay,
        period = period,
        successThreshold = successThreshold,
        timeout = timeout,
    )
}
