@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.PyTorchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * PyTorch distribution configuration.
 * @property distributionType Enum to determine the job distribution type.
 * Expected value is 'PyTorch'.
 * @property processCountPerInstance Number of processes per node.
 */
public data class PyTorchArgs(
    public val distributionType: Output<String>,
    public val processCountPerInstance: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.PyTorchArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.PyTorchArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.PyTorchArgs.builder()
            .distributionType(distributionType.applyValue({ args0 -> args0 }))
            .processCountPerInstance(processCountPerInstance?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PyTorchArgs].
 */
@PulumiTagMarker
public class PyTorchArgsBuilder internal constructor() {
    private var distributionType: Output<String>? = null

    private var processCountPerInstance: Output<Int>? = null

    /**
     * @param value Enum to determine the job distribution type.
     * Expected value is 'PyTorch'.
     */
    @JvmName("xqetdutefslmqrsm")
    public suspend fun distributionType(`value`: Output<String>) {
        this.distributionType = value
    }

    /**
     * @param value Number of processes per node.
     */
    @JvmName("rungrutoobyvnhny")
    public suspend fun processCountPerInstance(`value`: Output<Int>) {
        this.processCountPerInstance = value
    }

    /**
     * @param value Enum to determine the job distribution type.
     * Expected value is 'PyTorch'.
     */
    @JvmName("whyuwcmwuedwxank")
    public suspend fun distributionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.distributionType = mapped
    }

    /**
     * @param value Number of processes per node.
     */
    @JvmName("eomgyicmlmlknvnx")
    public suspend fun processCountPerInstance(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processCountPerInstance = mapped
    }

    internal fun build(): PyTorchArgs = PyTorchArgs(
        distributionType = distributionType ?: throw PulumiNullFieldException("distributionType"),
        processCountPerInstance = processCountPerInstance,
    )
}
