@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.RegistryPrivateEndpointConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Private endpoint connection definition.
 * @property id This is the private endpoint connection name created on SRP
 * Full resource id: /subscriptions/{subId}/resourceGroups/{rgName}/providers/Microsoft.MachineLearningServices/{resourceType}/{resourceName}/privateEndpointConnections/{peConnectionName}
 * @property location Same as workspace location.
 * @property properties Properties of the Private Endpoint Connection
 */
public data class RegistryPrivateEndpointConnectionArgs(
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<RegistryPrivateEndpointConnectionPropertiesArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.RegistryPrivateEndpointConnectionArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.RegistryPrivateEndpointConnectionArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.RegistryPrivateEndpointConnectionArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RegistryPrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class RegistryPrivateEndpointConnectionArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<RegistryPrivateEndpointConnectionPropertiesArgs>? = null

    /**
     * @param value This is the private endpoint connection name created on SRP
     * Full resource id: /subscriptions/{subId}/resourceGroups/{rgName}/providers/Microsoft.MachineLearningServices/{resourceType}/{resourceName}/privateEndpointConnections/{peConnectionName}
     */
    @JvmName("vwwrymhqmdqwvjnd")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Same as workspace location.
     */
    @JvmName("qlyysnebcvpmijml")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Properties of the Private Endpoint Connection
     */
    @JvmName("msnvdsacvjrvrjbl")
    public suspend fun properties(`value`: Output<RegistryPrivateEndpointConnectionPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value This is the private endpoint connection name created on SRP
     * Full resource id: /subscriptions/{subId}/resourceGroups/{rgName}/providers/Microsoft.MachineLearningServices/{resourceType}/{resourceName}/privateEndpointConnections/{peConnectionName}
     */
    @JvmName("uljqvdmbdoojedfa")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Same as workspace location.
     */
    @JvmName("qkhuqpbvosefalcj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Properties of the Private Endpoint Connection
     */
    @JvmName("oftggijocneibped")
    public suspend fun properties(`value`: RegistryPrivateEndpointConnectionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the Private Endpoint Connection
     */
    @JvmName("tavdvjlnkqahpsam")
    public suspend
    fun properties(argument: suspend RegistryPrivateEndpointConnectionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = RegistryPrivateEndpointConnectionPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): RegistryPrivateEndpointConnectionArgs =
        RegistryPrivateEndpointConnectionArgs(
            id = id,
            location = location,
            properties = properties,
        )
}
