@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.RegistryPrivateEndpointConnectionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of the Private Endpoint Connection
 * @property groupIds The group ids
 * @property privateEndpoint The PE network resource that is linked to this PE connection.
 * @property privateLinkServiceConnectionState The connection state.
 * @property provisioningState One of null, "Succeeded", "Provisioning", "Failed". While not approved, it's null.
 */
public data class RegistryPrivateEndpointConnectionPropertiesArgs(
    public val groupIds: Output<List<String>>? = null,
    public val privateEndpoint: Output<PrivateEndpointResourceArgs>? = null,
    public val privateLinkServiceConnectionState:
    Output<RegistryPrivateLinkServiceConnectionStateArgs>? = null,
    public val provisioningState: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.RegistryPrivateEndpointConnectionPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.RegistryPrivateEndpointConnectionPropertiesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.RegistryPrivateEndpointConnectionPropertiesArgs.builder()
            .groupIds(groupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateEndpoint(privateEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryPrivateEndpointConnectionPropertiesArgs].
 */
@PulumiTagMarker
public class RegistryPrivateEndpointConnectionPropertiesArgsBuilder internal constructor() {
    private var groupIds: Output<List<String>>? = null

    private var privateEndpoint: Output<PrivateEndpointResourceArgs>? = null

    private var privateLinkServiceConnectionState:
        Output<RegistryPrivateLinkServiceConnectionStateArgs>? = null

    private var provisioningState: Output<String>? = null

    /**
     * @param value The group ids
     */
    @JvmName("mclsagirapiufqge")
    public suspend fun groupIds(`value`: Output<List<String>>) {
        this.groupIds = value
    }

    @JvmName("ggdfltmxtxqpswvj")
    public suspend fun groupIds(vararg values: Output<String>) {
        this.groupIds = Output.all(values.asList())
    }

    /**
     * @param values The group ids
     */
    @JvmName("adqciylqdsmitvxk")
    public suspend fun groupIds(values: List<Output<String>>) {
        this.groupIds = Output.all(values)
    }

    /**
     * @param value The PE network resource that is linked to this PE connection.
     */
    @JvmName("lrvvhpaqagsxgpod")
    public suspend fun privateEndpoint(`value`: Output<PrivateEndpointResourceArgs>) {
        this.privateEndpoint = value
    }

    /**
     * @param value The connection state.
     */
    @JvmName("hdwdmebshpfryujm")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<RegistryPrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value One of null, "Succeeded", "Provisioning", "Failed". While not approved, it's null.
     */
    @JvmName("wlggxfqlsnfeycoq")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value The group ids
     */
    @JvmName("fpmfawfdrbiutele")
    public suspend fun groupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param values The group ids
     */
    @JvmName("mgmioddfkontnmik")
    public suspend fun groupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param value The PE network resource that is linked to this PE connection.
     */
    @JvmName("fquimkkqkwfwsdef")
    public suspend fun privateEndpoint(`value`: PrivateEndpointResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpoint = mapped
    }

    /**
     * @param argument The PE network resource that is linked to this PE connection.
     */
    @JvmName("bionyqqhoqfoodmu")
    public suspend
    fun privateEndpoint(argument: suspend PrivateEndpointResourceArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateEndpoint = mapped
    }

    /**
     * @param value The connection state.
     */
    @JvmName("iuovwkqoijqhnfkp")
    public suspend
    fun privateLinkServiceConnectionState(`value`: RegistryPrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument The connection state.
     */
    @JvmName("tbkalvwefewlolkc")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend RegistryPrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = RegistryPrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value One of null, "Succeeded", "Provisioning", "Failed". While not approved, it's null.
     */
    @JvmName("assifbokcgixfydm")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    internal fun build(): RegistryPrivateEndpointConnectionPropertiesArgs =
        RegistryPrivateEndpointConnectionPropertiesArgs(
            groupIds = groupIds,
            privateEndpoint = privateEndpoint,
            privateLinkServiceConnectionState = privateLinkServiceConnectionState,
            provisioningState = provisioningState,
        )
}
