@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.RequestConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Scoring requests configuration.
 * @property maxConcurrentRequestsPerInstance The number of maximum concurrent requests per node allowed per deployment. Defaults to 1.
 * @property requestTimeout The scoring timeout in ISO 8601 format.
 * Defaults to 5000ms.
 */
public data class RequestConfigurationArgs(
    public val maxConcurrentRequestsPerInstance: Output<Int>? = null,
    public val requestTimeout: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.RequestConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.RequestConfigurationArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.RequestConfigurationArgs.builder()
            .maxConcurrentRequestsPerInstance(maxConcurrentRequestsPerInstance?.applyValue({ args0 -> args0 }))
            .requestTimeout(requestTimeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RequestConfigurationArgs].
 */
@PulumiTagMarker
public class RequestConfigurationArgsBuilder internal constructor() {
    private var maxConcurrentRequestsPerInstance: Output<Int>? = null

    private var requestTimeout: Output<String>? = null

    /**
     * @param value The number of maximum concurrent requests per node allowed per deployment. Defaults to 1.
     */
    @JvmName("urlrkvuldsxgoffg")
    public suspend fun maxConcurrentRequestsPerInstance(`value`: Output<Int>) {
        this.maxConcurrentRequestsPerInstance = value
    }

    /**
     * @param value The scoring timeout in ISO 8601 format.
     * Defaults to 5000ms.
     */
    @JvmName("bixsueuywkdkerwf")
    public suspend fun requestTimeout(`value`: Output<String>) {
        this.requestTimeout = value
    }

    /**
     * @param value The number of maximum concurrent requests per node allowed per deployment. Defaults to 1.
     */
    @JvmName("jsiapivttajjysmk")
    public suspend fun maxConcurrentRequestsPerInstance(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentRequestsPerInstance = mapped
    }

    /**
     * @param value The scoring timeout in ISO 8601 format.
     * Defaults to 5000ms.
     */
    @JvmName("drfufcnytvevstkn")
    public suspend fun requestTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestTimeout = mapped
    }

    internal fun build(): RequestConfigurationArgs = RequestConfigurationArgs(
        maxConcurrentRequestsPerInstance = maxConcurrentRequestsPerInstance,
        requestTimeout = requestTimeout,
    )
}
