@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ResourceIdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a resource ID. For example, for a subnet, it is the resource URL for the subnet.
 * @property id The ID of the resource
 */
public data class ResourceIdArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ResourceIdArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ResourceIdArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ResourceIdArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceIdArgs].
 */
@PulumiTagMarker
public class ResourceIdArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value The ID of the resource
     */
    @JvmName("aeprmktohotogiya")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The ID of the resource
     */
    @JvmName("ogijvydmcwlsiexf")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): ResourceIdArgs = ResourceIdArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
