@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.SasDatastoreCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * SAS datastore credentials configuration.
 * @property credentialsType Enum to determine the datastore credentials type.
 * Expected value is 'Sas'.
 * @property secrets [Required] Storage container secrets.
 */
public data class SasDatastoreCredentialsArgs(
    public val credentialsType: Output<String>,
    public val secrets: Output<SasDatastoreSecretsArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.SasDatastoreCredentialsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.SasDatastoreCredentialsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.SasDatastoreCredentialsArgs.builder()
            .credentialsType(credentialsType.applyValue({ args0 -> args0 }))
            .secrets(secrets.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SasDatastoreCredentialsArgs].
 */
@PulumiTagMarker
public class SasDatastoreCredentialsArgsBuilder internal constructor() {
    private var credentialsType: Output<String>? = null

    private var secrets: Output<SasDatastoreSecretsArgs>? = null

    /**
     * @param value Enum to determine the datastore credentials type.
     * Expected value is 'Sas'.
     */
    @JvmName("iivlxqqdhpjfptnj")
    public suspend fun credentialsType(`value`: Output<String>) {
        this.credentialsType = value
    }

    /**
     * @param value [Required] Storage container secrets.
     */
    @JvmName("yifnrwyuwtenseus")
    public suspend fun secrets(`value`: Output<SasDatastoreSecretsArgs>) {
        this.secrets = value
    }

    /**
     * @param value Enum to determine the datastore credentials type.
     * Expected value is 'Sas'.
     */
    @JvmName("pehbvsmalobhxxch")
    public suspend fun credentialsType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentialsType = mapped
    }

    /**
     * @param value [Required] Storage container secrets.
     */
    @JvmName("ydgxyireoxslulqf")
    public suspend fun secrets(`value`: SasDatastoreSecretsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param argument [Required] Storage container secrets.
     */
    @JvmName("gfsmhpwcedkpoycd")
    public suspend fun secrets(argument: suspend SasDatastoreSecretsArgsBuilder.() -> Unit) {
        val toBeMapped = SasDatastoreSecretsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    internal fun build(): SasDatastoreCredentialsArgs = SasDatastoreCredentialsArgs(
        credentialsType = credentialsType ?: throw PulumiNullFieldException("credentialsType"),
        secrets = secrets ?: throw PulumiNullFieldException("secrets"),
    )
}
