@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ScaleSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * scale settings for AML Compute
 * @property maxNodeCount Max number of nodes to use
 * @property minNodeCount Min number of nodes to use
 * @property nodeIdleTimeBeforeScaleDown Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format.
 */
public data class ScaleSettingsArgs(
    public val maxNodeCount: Output<Int>,
    public val minNodeCount: Output<Int>? = null,
    public val nodeIdleTimeBeforeScaleDown: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ScaleSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ScaleSettingsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ScaleSettingsArgs.builder()
            .maxNodeCount(maxNodeCount.applyValue({ args0 -> args0 }))
            .minNodeCount(minNodeCount?.applyValue({ args0 -> args0 }))
            .nodeIdleTimeBeforeScaleDown(nodeIdleTimeBeforeScaleDown?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScaleSettingsArgs].
 */
@PulumiTagMarker
public class ScaleSettingsArgsBuilder internal constructor() {
    private var maxNodeCount: Output<Int>? = null

    private var minNodeCount: Output<Int>? = null

    private var nodeIdleTimeBeforeScaleDown: Output<String>? = null

    /**
     * @param value Max number of nodes to use
     */
    @JvmName("argerrrqvypqynod")
    public suspend fun maxNodeCount(`value`: Output<Int>) {
        this.maxNodeCount = value
    }

    /**
     * @param value Min number of nodes to use
     */
    @JvmName("yhasqspsdnbqsdym")
    public suspend fun minNodeCount(`value`: Output<Int>) {
        this.minNodeCount = value
    }

    /**
     * @param value Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format.
     */
    @JvmName("cbvjlmjihyxssgak")
    public suspend fun nodeIdleTimeBeforeScaleDown(`value`: Output<String>) {
        this.nodeIdleTimeBeforeScaleDown = value
    }

    /**
     * @param value Max number of nodes to use
     */
    @JvmName("udbmgbvryeetebwt")
    public suspend fun maxNodeCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxNodeCount = mapped
    }

    /**
     * @param value Min number of nodes to use
     */
    @JvmName("kpxdiacrixysvftl")
    public suspend fun minNodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minNodeCount = mapped
    }

    /**
     * @param value Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format.
     */
    @JvmName("wfbgjubyrcnkxvaa")
    public suspend fun nodeIdleTimeBeforeScaleDown(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeIdleTimeBeforeScaleDown = mapped
    }

    internal fun build(): ScaleSettingsArgs = ScaleSettingsArgs(
        maxNodeCount = maxNodeCount ?: throw PulumiNullFieldException("maxNodeCount"),
        minNodeCount = minNodeCount,
        nodeIdleTimeBeforeScaleDown = nodeIdleTimeBeforeScaleDown,
    )
}
