@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ServicePrincipalDatastoreCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Service Principal datastore credentials configuration.
 * @property authorityUrl Authority URL used for authentication.
 * @property clientId [Required] Service principal client ID.
 * @property credentialsType Enum to determine the datastore credentials type.
 * Expected value is 'ServicePrincipal'.
 * @property resourceUrl Resource the service principal has access to.
 * @property secrets [Required] Service principal secrets.
 * @property tenantId [Required] ID of the tenant to which the service principal belongs.
 */
public data class ServicePrincipalDatastoreCredentialsArgs(
    public val authorityUrl: Output<String>? = null,
    public val clientId: Output<String>,
    public val credentialsType: Output<String>,
    public val resourceUrl: Output<String>? = null,
    public val secrets: Output<ServicePrincipalDatastoreSecretsArgs>,
    public val tenantId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ServicePrincipalDatastoreCredentialsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.ServicePrincipalDatastoreCredentialsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ServicePrincipalDatastoreCredentialsArgs.builder()
            .authorityUrl(authorityUrl?.applyValue({ args0 -> args0 }))
            .clientId(clientId.applyValue({ args0 -> args0 }))
            .credentialsType(credentialsType.applyValue({ args0 -> args0 }))
            .resourceUrl(resourceUrl?.applyValue({ args0 -> args0 }))
            .secrets(secrets.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tenantId(tenantId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServicePrincipalDatastoreCredentialsArgs].
 */
@PulumiTagMarker
public class ServicePrincipalDatastoreCredentialsArgsBuilder internal constructor() {
    private var authorityUrl: Output<String>? = null

    private var clientId: Output<String>? = null

    private var credentialsType: Output<String>? = null

    private var resourceUrl: Output<String>? = null

    private var secrets: Output<ServicePrincipalDatastoreSecretsArgs>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value Authority URL used for authentication.
     */
    @JvmName("fjukqwpnvwpcunop")
    public suspend fun authorityUrl(`value`: Output<String>) {
        this.authorityUrl = value
    }

    /**
     * @param value [Required] Service principal client ID.
     */
    @JvmName("ihsqqearffgbutid")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value Enum to determine the datastore credentials type.
     * Expected value is 'ServicePrincipal'.
     */
    @JvmName("ohnmomvgyuevvoia")
    public suspend fun credentialsType(`value`: Output<String>) {
        this.credentialsType = value
    }

    /**
     * @param value Resource the service principal has access to.
     */
    @JvmName("apumnfaeeyhtijwa")
    public suspend fun resourceUrl(`value`: Output<String>) {
        this.resourceUrl = value
    }

    /**
     * @param value [Required] Service principal secrets.
     */
    @JvmName("yucfhiwrfryueaev")
    public suspend fun secrets(`value`: Output<ServicePrincipalDatastoreSecretsArgs>) {
        this.secrets = value
    }

    /**
     * @param value [Required] ID of the tenant to which the service principal belongs.
     */
    @JvmName("unoejrdvjcfiqahn")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Authority URL used for authentication.
     */
    @JvmName("oliyacwesonhkcod")
    public suspend fun authorityUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorityUrl = mapped
    }

    /**
     * @param value [Required] Service principal client ID.
     */
    @JvmName("tydwfxbjvuugliuc")
    public suspend fun clientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value Enum to determine the datastore credentials type.
     * Expected value is 'ServicePrincipal'.
     */
    @JvmName("kebnjgicuwsxsypu")
    public suspend fun credentialsType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentialsType = mapped
    }

    /**
     * @param value Resource the service principal has access to.
     */
    @JvmName("wvxoxgwlqdermvor")
    public suspend fun resourceUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUrl = mapped
    }

    /**
     * @param value [Required] Service principal secrets.
     */
    @JvmName("cgjxcrtcuejadkfw")
    public suspend fun secrets(`value`: ServicePrincipalDatastoreSecretsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param argument [Required] Service principal secrets.
     */
    @JvmName("hipsaullsqerrisv")
    public suspend
    fun secrets(argument: suspend ServicePrincipalDatastoreSecretsArgsBuilder.() -> Unit) {
        val toBeMapped = ServicePrincipalDatastoreSecretsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param value [Required] ID of the tenant to which the service principal belongs.
     */
    @JvmName("hnvjmgrvrcvjaxei")
    public suspend fun tenantId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): ServicePrincipalDatastoreCredentialsArgs =
        ServicePrincipalDatastoreCredentialsArgs(
            authorityUrl = authorityUrl,
            clientId = clientId ?: throw PulumiNullFieldException("clientId"),
            credentialsType = credentialsType ?: throw PulumiNullFieldException("credentialsType"),
            resourceUrl = resourceUrl,
            secrets = secrets ?: throw PulumiNullFieldException("secrets"),
            tenantId = tenantId ?: throw PulumiNullFieldException("tenantId"),
        )
}
