@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ServiceTagOutboundRuleArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.RuleCategory
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.RuleStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Service Tag Outbound Rule for the managed network of a machine learning workspace.
 * @property category Category of a managed network Outbound Rule of a machine learning workspace.
 * @property destination Service Tag destination for a Service Tag Outbound Rule for the managed network of a machine learning workspace.
 * @property status Status of a managed network Outbound Rule of a machine learning workspace.
 * @property type Type of a managed network Outbound Rule of a machine learning workspace.
 * Expected value is 'ServiceTag'.
 */
public data class ServiceTagOutboundRuleArgs(
    public val category: Output<Either<String, RuleCategory>>? = null,
    public val destination: Output<ServiceTagDestinationArgs>? = null,
    public val status: Output<Either<String, RuleStatus>>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ServiceTagOutboundRuleArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.ServiceTagOutboundRuleArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ServiceTagOutboundRuleArgs.builder()
            .category(
                category?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .destination(destination?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceTagOutboundRuleArgs].
 */
@PulumiTagMarker
public class ServiceTagOutboundRuleArgsBuilder internal constructor() {
    private var category: Output<Either<String, RuleCategory>>? = null

    private var destination: Output<ServiceTagDestinationArgs>? = null

    private var status: Output<Either<String, RuleStatus>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Category of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("hnatgksnyobjrvef")
    public suspend fun category(`value`: Output<Either<String, RuleCategory>>) {
        this.category = value
    }

    /**
     * @param value Service Tag destination for a Service Tag Outbound Rule for the managed network of a machine learning workspace.
     */
    @JvmName("oyeuebtfocwkfirb")
    public suspend fun destination(`value`: Output<ServiceTagDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value Status of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("iekkdtqclpuhtcbb")
    public suspend fun status(`value`: Output<Either<String, RuleStatus>>) {
        this.status = value
    }

    /**
     * @param value Type of a managed network Outbound Rule of a machine learning workspace.
     * Expected value is 'ServiceTag'.
     */
    @JvmName("lohynapftnfmwbmc")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Category of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("yemxlbumecrvrjqy")
    public suspend fun category(`value`: Either<String, RuleCategory>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Category of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("kltjtduqptywpury")
    public fun category(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RuleCategory>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Category of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("tbnwrnyhbekeaxxf")
    public fun category(`value`: RuleCategory) {
        val toBeMapped = Either.ofRight<String, RuleCategory>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Service Tag destination for a Service Tag Outbound Rule for the managed network of a machine learning workspace.
     */
    @JvmName("xlppweooywmjsitd")
    public suspend fun destination(`value`: ServiceTagDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument Service Tag destination for a Service Tag Outbound Rule for the managed network of a machine learning workspace.
     */
    @JvmName("ckrqcpblvtakkkwy")
    public suspend fun destination(argument: suspend ServiceTagDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceTagDestinationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    /**
     * @param value Status of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("xtfnbuttirfbgjgk")
    public suspend fun status(`value`: Either<String, RuleStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("kwbyuxqrltgmhbtx")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RuleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("achubmnhydawgihi")
    public fun status(`value`: RuleStatus) {
        val toBeMapped = Either.ofRight<String, RuleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Type of a managed network Outbound Rule of a machine learning workspace.
     * Expected value is 'ServiceTag'.
     */
    @JvmName("kkqsmepcjtmwgsox")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServiceTagOutboundRuleArgs = ServiceTagOutboundRuleArgs(
        category = category,
        destination = destination,
        status = status,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
