@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.StorageAccountDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Details of storage account to be used for the Registry
 * @property systemCreatedStorageAccount Details of system created storage account to be used for the registry
 * @property userCreatedStorageAccount Details of user created storage account to be used for the registry
 */
public data class StorageAccountDetailsArgs(
    public val systemCreatedStorageAccount: Output<SystemCreatedStorageAccountArgs>? = null,
    public val userCreatedStorageAccount: Output<UserCreatedStorageAccountArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.StorageAccountDetailsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.StorageAccountDetailsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.StorageAccountDetailsArgs.builder()
            .systemCreatedStorageAccount(
                systemCreatedStorageAccount?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .userCreatedStorageAccount(
                userCreatedStorageAccount?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [StorageAccountDetailsArgs].
 */
@PulumiTagMarker
public class StorageAccountDetailsArgsBuilder internal constructor() {
    private var systemCreatedStorageAccount: Output<SystemCreatedStorageAccountArgs>? = null

    private var userCreatedStorageAccount: Output<UserCreatedStorageAccountArgs>? = null

    /**
     * @param value Details of system created storage account to be used for the registry
     */
    @JvmName("cmshqkiwcdxgdnxg")
    public suspend fun systemCreatedStorageAccount(`value`: Output<SystemCreatedStorageAccountArgs>) {
        this.systemCreatedStorageAccount = value
    }

    /**
     * @param value Details of user created storage account to be used for the registry
     */
    @JvmName("ywlsyeoshofspcqp")
    public suspend fun userCreatedStorageAccount(`value`: Output<UserCreatedStorageAccountArgs>) {
        this.userCreatedStorageAccount = value
    }

    /**
     * @param value Details of system created storage account to be used for the registry
     */
    @JvmName("cafsbvdgqyjoopqu")
    public suspend fun systemCreatedStorageAccount(`value`: SystemCreatedStorageAccountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemCreatedStorageAccount = mapped
    }

    /**
     * @param argument Details of system created storage account to be used for the registry
     */
    @JvmName("cnfippdkudywwmho")
    public suspend
    fun systemCreatedStorageAccount(argument: suspend SystemCreatedStorageAccountArgsBuilder.() -> Unit) {
        val toBeMapped = SystemCreatedStorageAccountArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.systemCreatedStorageAccount = mapped
    }

    /**
     * @param value Details of user created storage account to be used for the registry
     */
    @JvmName("qaalfljoeqvecpec")
    public suspend fun userCreatedStorageAccount(`value`: UserCreatedStorageAccountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userCreatedStorageAccount = mapped
    }

    /**
     * @param argument Details of user created storage account to be used for the registry
     */
    @JvmName("mwcqpiscyctdqrob")
    public suspend
    fun userCreatedStorageAccount(argument: suspend UserCreatedStorageAccountArgsBuilder.() -> Unit) {
        val toBeMapped = UserCreatedStorageAccountArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.userCreatedStorageAccount = mapped
    }

    internal fun build(): StorageAccountDetailsArgs = StorageAccountDetailsArgs(
        systemCreatedStorageAccount = systemCreatedStorageAccount,
        userCreatedStorageAccount = userCreatedStorageAccount,
    )
}
