@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.TargetUtilizationScaleSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxInstances The maximum number of instances that the deployment can scale to. The quota will be reserved for max_instances.
 * @property minInstances The minimum number of instances to always be present.
 * @property pollingInterval The polling interval in ISO 8691 format. Only supports duration with precision as low as Seconds.
 * @property scaleType
 * Expected value is 'TargetUtilization'.
 * @property targetUtilizationPercentage Target CPU usage for the autoscaler.
 */
public data class TargetUtilizationScaleSettingsArgs(
    public val maxInstances: Output<Int>? = null,
    public val minInstances: Output<Int>? = null,
    public val pollingInterval: Output<String>? = null,
    public val scaleType: Output<String>,
    public val targetUtilizationPercentage: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.TargetUtilizationScaleSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.TargetUtilizationScaleSettingsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.TargetUtilizationScaleSettingsArgs.builder()
            .maxInstances(maxInstances?.applyValue({ args0 -> args0 }))
            .minInstances(minInstances?.applyValue({ args0 -> args0 }))
            .pollingInterval(pollingInterval?.applyValue({ args0 -> args0 }))
            .scaleType(scaleType.applyValue({ args0 -> args0 }))
            .targetUtilizationPercentage(targetUtilizationPercentage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TargetUtilizationScaleSettingsArgs].
 */
@PulumiTagMarker
public class TargetUtilizationScaleSettingsArgsBuilder internal constructor() {
    private var maxInstances: Output<Int>? = null

    private var minInstances: Output<Int>? = null

    private var pollingInterval: Output<String>? = null

    private var scaleType: Output<String>? = null

    private var targetUtilizationPercentage: Output<Int>? = null

    /**
     * @param value The maximum number of instances that the deployment can scale to. The quota will be reserved for max_instances.
     */
    @JvmName("uarinpprnowrlhir")
    public suspend fun maxInstances(`value`: Output<Int>) {
        this.maxInstances = value
    }

    /**
     * @param value The minimum number of instances to always be present.
     */
    @JvmName("gplgnjynjpmpbfod")
    public suspend fun minInstances(`value`: Output<Int>) {
        this.minInstances = value
    }

    /**
     * @param value The polling interval in ISO 8691 format. Only supports duration with precision as low as Seconds.
     */
    @JvmName("totjyvxnocdfenny")
    public suspend fun pollingInterval(`value`: Output<String>) {
        this.pollingInterval = value
    }

    /**
     * @param value
     * Expected value is 'TargetUtilization'.
     */
    @JvmName("usorwtjbebmaipmk")
    public suspend fun scaleType(`value`: Output<String>) {
        this.scaleType = value
    }

    /**
     * @param value Target CPU usage for the autoscaler.
     */
    @JvmName("wxuomgpqbkkgmmnq")
    public suspend fun targetUtilizationPercentage(`value`: Output<Int>) {
        this.targetUtilizationPercentage = value
    }

    /**
     * @param value The maximum number of instances that the deployment can scale to. The quota will be reserved for max_instances.
     */
    @JvmName("klxkmsxmrfeinjdr")
    public suspend fun maxInstances(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxInstances = mapped
    }

    /**
     * @param value The minimum number of instances to always be present.
     */
    @JvmName("bwvuqftvswoueott")
    public suspend fun minInstances(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minInstances = mapped
    }

    /**
     * @param value The polling interval in ISO 8691 format. Only supports duration with precision as low as Seconds.
     */
    @JvmName("irxqxhjyjxkurwyy")
    public suspend fun pollingInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pollingInterval = mapped
    }

    /**
     * @param value
     * Expected value is 'TargetUtilization'.
     */
    @JvmName("vjlbxxcdnuggmetf")
    public suspend fun scaleType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleType = mapped
    }

    /**
     * @param value Target CPU usage for the autoscaler.
     */
    @JvmName("dskfbqxmrtrqhbvr")
    public suspend fun targetUtilizationPercentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetUtilizationPercentage = mapped
    }

    internal fun build(): TargetUtilizationScaleSettingsArgs = TargetUtilizationScaleSettingsArgs(
        maxInstances = maxInstances,
        minInstances = minInstances,
        pollingInterval = pollingInterval,
        scaleType = scaleType ?: throw PulumiNullFieldException("scaleType"),
        targetUtilizationPercentage = targetUtilizationPercentage,
    )
}
