@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.TmpfsOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the tmpfs options for the container
 * @property size Mention the Tmpfs size
 */
public data class TmpfsOptionsArgs(
    public val size: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.TmpfsOptionsArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.TmpfsOptionsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.TmpfsOptionsArgs.builder()
            .size(size?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TmpfsOptionsArgs].
 */
@PulumiTagMarker
public class TmpfsOptionsArgsBuilder internal constructor() {
    private var size: Output<Int>? = null

    /**
     * @param value Mention the Tmpfs size
     */
    @JvmName("eupqjqfnyuyggcfg")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value Mention the Tmpfs size
     */
    @JvmName("nocykbrlfbubnnkg")
    public suspend fun size(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    internal fun build(): TmpfsOptionsArgs = TmpfsOptionsArgs(
        size = size,
    )
}
