@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.UserAccountCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Settings for user account that gets created on each on the nodes of a compute.
 * @property adminUserName Name of the administrator user account which can be used to SSH to nodes.
 * @property adminUserPassword Password of the administrator user account.
 * @property adminUserSshPublicKey SSH public key of the administrator user account.
 */
public data class UserAccountCredentialsArgs(
    public val adminUserName: Output<String>,
    public val adminUserPassword: Output<String>? = null,
    public val adminUserSshPublicKey: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.UserAccountCredentialsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.UserAccountCredentialsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.UserAccountCredentialsArgs.builder()
            .adminUserName(adminUserName.applyValue({ args0 -> args0 }))
            .adminUserPassword(adminUserPassword?.applyValue({ args0 -> args0 }))
            .adminUserSshPublicKey(adminUserSshPublicKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserAccountCredentialsArgs].
 */
@PulumiTagMarker
public class UserAccountCredentialsArgsBuilder internal constructor() {
    private var adminUserName: Output<String>? = null

    private var adminUserPassword: Output<String>? = null

    private var adminUserSshPublicKey: Output<String>? = null

    /**
     * @param value Name of the administrator user account which can be used to SSH to nodes.
     */
    @JvmName("mcosjvkywuwgrpwy")
    public suspend fun adminUserName(`value`: Output<String>) {
        this.adminUserName = value
    }

    /**
     * @param value Password of the administrator user account.
     */
    @JvmName("sjamoixqyfuuaxnb")
    public suspend fun adminUserPassword(`value`: Output<String>) {
        this.adminUserPassword = value
    }

    /**
     * @param value SSH public key of the administrator user account.
     */
    @JvmName("bskurccsebtfnkya")
    public suspend fun adminUserSshPublicKey(`value`: Output<String>) {
        this.adminUserSshPublicKey = value
    }

    /**
     * @param value Name of the administrator user account which can be used to SSH to nodes.
     */
    @JvmName("aeyspirceovtnwqx")
    public suspend fun adminUserName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adminUserName = mapped
    }

    /**
     * @param value Password of the administrator user account.
     */
    @JvmName("ssowdseqghftyqpd")
    public suspend fun adminUserPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminUserPassword = mapped
    }

    /**
     * @param value SSH public key of the administrator user account.
     */
    @JvmName("eclarkvgcobacujc")
    public suspend fun adminUserSshPublicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminUserSshPublicKey = mapped
    }

    internal fun build(): UserAccountCredentialsArgs = UserAccountCredentialsArgs(
        adminUserName = adminUserName ?: throw PulumiNullFieldException("adminUserName"),
        adminUserPassword = adminUserPassword,
        adminUserSshPublicKey = adminUserSshPublicKey,
    )
}
