@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.VirtualMachineImageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Virtual Machine image for Windows AML Compute
 * @property id Virtual Machine image path
 */
public data class VirtualMachineImageArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.VirtualMachineImageArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.VirtualMachineImageArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.VirtualMachineImageArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineImageArgs].
 */
@PulumiTagMarker
public class VirtualMachineImageArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Virtual Machine image path
     */
    @JvmName("hfahhrumibsgmctr")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Virtual Machine image path
     */
    @JvmName("qgyahmijolyihdod")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): VirtualMachineImageArgs = VirtualMachineImageArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
