@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.WorkspaceConnectionManagedIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clientId
 * @property resourceId
 */
public data class WorkspaceConnectionManagedIdentityArgs(
    public val clientId: Output<String>? = null,
    public val resourceId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.WorkspaceConnectionManagedIdentityArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.WorkspaceConnectionManagedIdentityArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.WorkspaceConnectionManagedIdentityArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceConnectionManagedIdentityArgs].
 */
@PulumiTagMarker
public class WorkspaceConnectionManagedIdentityArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("hhtghvtwftbbveft")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value
     */
    @JvmName("qobukwjbmsfvnvlf")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value
     */
    @JvmName("vlnihmpyhudgwkqh")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value
     */
    @JvmName("vowqobmhvhicgwgq")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): WorkspaceConnectionManagedIdentityArgs =
        WorkspaceConnectionManagedIdentityArgs(
            clientId = clientId,
            resourceId = resourceId,
        )
}
