@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property allocated Gets or sets the total number of instances for the group.
 * @property assignmentFailed Gets or sets the number of instances which failed to successfully complete assignment.
 * @property assignmentSuccess Gets or sets the number of instances which successfully completed assignment.
 */
public data class ActualCapacityInfoResponse(
    public val allocated: Int? = null,
    public val assignmentFailed: Int? = null,
    public val assignmentSuccess: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ActualCapacityInfoResponse):
            ActualCapacityInfoResponse = ActualCapacityInfoResponse(
            allocated = javaType.allocated().map({ args0 -> args0 }).orElse(null),
            assignmentFailed = javaType.assignmentFailed().map({ args0 -> args0 }).orElse(null),
            assignmentSuccess = javaType.assignmentSuccess().map({ args0 -> args0 }).orElse(null),
        )
    }
}
