@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Batch endpoint default values
 * @property deploymentName Name of the deployment that will be default for the endpoint.
 * This deployment will end up getting 100% traffic when the endpoint scoring URL is invoked.
 */
public data class BatchEndpointDefaultsResponse(
    public val deploymentName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.BatchEndpointDefaultsResponse):
            BatchEndpointDefaultsResponse = BatchEndpointDefaultsResponse(
            deploymentName = javaType.deploymentName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
