@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Describes the bind options for the container
 * @property createHostPath Indicate whether to create host path.
 * @property propagation Type of Bind Option
 * @property selinux Mention the selinux options.
 */
public data class BindOptionsResponse(
    public val createHostPath: Boolean? = null,
    public val propagation: String? = null,
    public val selinux: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.BindOptionsResponse):
            BindOptionsResponse = BindOptionsResponse(
            createHostPath = javaType.createHostPath().map({ args0 -> args0 }).orElse(null),
            propagation = javaType.propagation().map({ args0 -> args0 }).orElse(null),
            selinux = javaType.selinux().map({ args0 -> args0 }).orElse(null),
        )
    }
}
